/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionMulti;
import org.apache.cassandra.stress.settings.OptionSimple;

public final class OptionEnumProbabilities<T>
extends OptionMulti {
    final List<OptMatcher<T>> options;

    public OptionEnumProbabilities(List<Opt<T>> universe, String name, String description) {
        super(name, description, false);
        ArrayList<OptMatcher<T>> options = new ArrayList<OptMatcher<T>>();
        for (Opt<T> option : universe) {
            options.add(new OptMatcher(option.option, option.defaultValue));
        }
        this.options = options;
    }

    @Override
    public List<? extends Option> options() {
        return this.options;
    }

    Map<T, Double> ratios() {
        List<Option> ratiosIn = this.setByUser() ? this.optionsSetByUser() : this.defaultOptions();
        HashMap ratiosOut = new HashMap();
        for (Option opt : ratiosIn) {
            OptMatcher optMatcher = (OptMatcher)opt;
            double d = Double.parseDouble(optMatcher.value());
            ratiosOut.put(optMatcher.opt, d);
        }
        return ratiosOut;
    }

    private static final class OptMatcher<T>
    extends OptionSimple {
        final T opt;

        OptMatcher(T opt, String defaultValue) {
            super(opt.toString().toLowerCase() + "=", "[0-9]+(\\.[0-9]+)?", defaultValue, "Performs this many " + opt + " operations out of total", false);
            this.opt = opt;
        }
    }

    public static class Opt<T> {
        final T option;
        final String defaultValue;

        public Opt(T option, String defaultValue) {
            this.option = option;
            this.defaultValue = defaultValue;
        }
    }
}

