/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.util;

import java.util.Iterator;
import org.psjava.util.ReadOnlyIterator;

public class MergedIterator {
    public static <T> Iterator<T> create(final Iterable<? extends Iterable<? extends T>> iterables) {
        return new ReadOnlyIterator<T>(){
            Iterator<? extends Iterable<? extends T>> topIterator;
            Iterator<? extends T> currentSubIterator;
            {
                this.topIterator = iterables.iterator();
                this.currentSubIterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this.currentSubIterator == null || !this.currentSubIterator.hasNext()) {
                    if (this.topIterator.hasNext()) {
                        this.currentSubIterator = this.topIterator.next().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                this.hasNext();
                return this.currentSubIterator.next();
            }
        };
    }

    private MergedIterator() {
    }
}

