/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.util;

import java.util.Iterator;
import org.psjava.util.AssertStatus;
import org.psjava.util.ReadOnlyIterator;

public class SingleElementIterator {
    public static <T> Iterator<T> create(final T value) {
        return new ReadOnlyIterator<T>(){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public T next() {
                AssertStatus.assertTrue(!this.read, "no item anymore");
                this.read = true;
                return value;
            }
        };
    }

    private SingleElementIterator() {
    }
}

