/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimestampSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampType
extends TemporalType<Date> {
    private static final Logger logger = LoggerFactory.getLogger(TimestampType.class);
    public static final TimestampType instance = new TimestampType();

    private TimestampType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return LongType.compareLongs(left, accessorL, right, accessorR);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return ByteBufferUtil.bytes(TimestampSerializer.dateStringToTimestamp(source));
    }

    @Override
    public ByteBuffer fromTimeInMillis(long millis) throws MarshalException {
        return ByteBufferUtil.bytes(millis);
    }

    @Override
    public long toTimeInMillis(ByteBuffer value) {
        return ByteBufferUtil.toLong(value);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof Long) {
            return new Constants.Value(ByteBufferUtil.bytes((Long)parsed));
        }
        try {
            return new Constants.Value(instance.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a long or a datestring representation of a timestamp value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    private String toString(Date date) {
        return date != null ? TimestampSerializer.getJsonDateFormatter().format(date.toInstant()) : "";
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return '\"' + this.toString((Date)TimestampSerializer.instance.deserialize(buffer)) + '\"';
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (super.isCompatibleWith(previous)) {
            return true;
        }
        if (previous instanceof DateType) {
            logger.warn("Changing from DateType to TimestampType is allowed, but be wary that they sort differently for pre-unix-epoch timestamps (negative timestamp values) and thus this change will corrupt your data if you have such negative timestamp. So unless you know that you don't have *any* pre-unix-epoch timestamp you should change back to DateType");
            return true;
        }
        return false;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == DateType.instance || otherType == LongType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMESTAMP;
    }

    @Override
    public TypeSerializer<Date> getSerializer() {
        return TimestampSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 8;
    }

    @Override
    protected void validateDuration(Duration duration) {
        if (!duration.hasMillisecondPrecision()) {
            throw RequestValidations.invalidRequest("The duration must have a millisecond precision. Was: %s", duration);
        }
    }
}

