/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;

public class FutureCombiner<T>
extends AsyncFuture<T> {
    private volatile Collection<? extends io.netty.util.concurrent.Future<?>> propagateCancellation;

    private FutureCombiner(Collection<? extends io.netty.util.concurrent.Future<?>> combine, Supplier<T> resultSupplier, ListenerFactory<T> listenerFactory) {
        if (combine.isEmpty()) {
            this.trySuccess((T)null);
        } else {
            Listener listener = listenerFactory.create(combine.size(), resultSupplier, this);
            combine.forEach(f -> {
                if (f.isDone()) {
                    listener.operationComplete((io.netty.util.concurrent.Future<Object>)f);
                } else {
                    f.addListener((GenericFutureListener)listener);
                }
            });
        }
    }

    @Override
    protected boolean setUncancellable() {
        if (!super.setUncancellable()) {
            return false;
        }
        this.propagateCancellation = null;
        return true;
    }

    @Override
    protected boolean setUncancellableExclusive() {
        if (!super.setUncancellableExclusive()) {
            return false;
        }
        this.propagateCancellation = null;
        return true;
    }

    @Override
    protected boolean trySuccess(T t) {
        if (!super.trySuccess(t)) {
            return false;
        }
        this.propagateCancellation = null;
        return true;
    }

    @Override
    protected boolean tryFailure(Throwable throwable) {
        if (!super.tryFailure(throwable)) {
            return false;
        }
        this.propagateCancellation = null;
        return true;
    }

    @Override
    public boolean cancel(boolean b) {
        if (!super.cancel(b)) {
            return false;
        }
        Collection<io.netty.util.concurrent.Future<?>> propagate = this.propagateCancellation;
        this.propagateCancellation = null;
        if (propagate != null) {
            propagate.forEach(f -> f.cancel(b));
        }
        return true;
    }

    public static FutureCombiner<Void> nettySuccessListener(Collection<? extends io.netty.util.concurrent.Future<?>> futures) {
        return new FutureCombiner<Void>(futures, () -> null, FailSlowListener::new){

            @Override
            public Executor notifyExecutor() {
                return GlobalEventExecutor.INSTANCE;
            }
        };
    }

    public static <V> Future<List<V>> allOf(Collection<? extends io.netty.util.concurrent.Future<? extends V>> futures) {
        if (futures.isEmpty()) {
            return ImmediateFuture.success(Collections.emptyList());
        }
        return new FutureCombiner<List<V>>(futures, () -> futures.stream().map((? super T f) -> f.getNow()).collect(Collectors.toList()), FailFastListener::new);
    }

    public static <V> Future<List<V>> successfulOf(List<? extends io.netty.util.concurrent.Future<V>> futures) {
        if (futures.isEmpty()) {
            return ImmediateFuture.success(Collections.emptyList());
        }
        return new FutureCombiner<List<V>>(futures, () -> futures.stream().map((? super T f) -> f.isSuccess() ? f.getNow() : null).collect(Collectors.toList()), Listener::new);
    }

    private static class FailSlowListener<T>
    extends Listener<T> {
        private static final AtomicReferenceFieldUpdater<FailSlowListener, Throwable> firstCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(FailSlowListener.class, Throwable.class, "firstCause");
        private volatile Throwable firstCause;

        FailSlowListener(int count, Supplier<T> onSuccess, FutureCombiner<T> complete) {
            super(count, onSuccess, complete);
        }

        @Override
        void onCompletion() {
            if (this.onSuccess == null) {
                this.complete.tryFailure(this.firstCause);
            } else {
                super.onCompletion();
            }
        }

        @Override
        public void operationComplete(io.netty.util.concurrent.Future<Object> result) {
            if (!result.isSuccess()) {
                this.onSuccess = null;
                firstCauseUpdater.compareAndSet(this, null, result.cause());
            }
            super.operationComplete(result);
        }
    }

    private static class FailFastListener<T>
    extends Listener<T> {
        FailFastListener(int count, Supplier<T> onSuccess, FutureCombiner<T> complete) {
            super(count, onSuccess, complete);
        }

        @Override
        public void operationComplete(io.netty.util.concurrent.Future<Object> result) {
            if (!result.isSuccess()) {
                this.onSuccess = null;
                this.complete.tryFailure(result.cause());
            } else {
                super.operationComplete(result);
            }
        }
    }

    private static class Listener<T>
    extends AtomicInteger
    implements GenericFutureListener<io.netty.util.concurrent.Future<Object>> {
        Supplier<T> onSuccess;
        final FutureCombiner<T> complete;

        Listener(int count, Supplier<T> onSuccess, FutureCombiner<T> complete) {
            super(count);
            Preconditions.checkNotNull(onSuccess);
            this.onSuccess = onSuccess;
            this.complete = complete;
        }

        public void operationComplete(io.netty.util.concurrent.Future<Object> result) {
            if (0 == this.decrementAndGet()) {
                this.onCompletion();
            }
        }

        void onCompletion() {
            this.complete.trySuccess(this.onSuccess.get());
            this.onSuccess = null;
        }
    }

    private static interface ListenerFactory<T> {
        public Listener<T> create(int var1, Supplier<T> var2, FutureCombiner<T> var3);
    }
}

