/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;

public abstract class GroupedOptions
implements Serializable {
    int accepted = 0;

    public boolean accept(String param) {
        for (Option option : this.options()) {
            if (!option.accept(param)) continue;
            ++this.accepted;
            return true;
        }
        return false;
    }

    public boolean happy() {
        for (Option option : this.options()) {
            if (option.happy()) continue;
            return false;
        }
        return true;
    }

    public abstract List<? extends Option> options();

    public static <G extends GroupedOptions> G select(String[] params, G ... groupings) {
        for (String param : params) {
            boolean accepted = false;
            for (G grouping : groupings) {
                accepted |= ((GroupedOptions)grouping).accept(param);
            }
            if (accepted) continue;
            throw new IllegalArgumentException("Invalid parameter " + param);
        }
        for (String grouping : groupings) {
            if (!((GroupedOptions)((Object)grouping)).happy() || ((GroupedOptions)((Object)grouping)).accepted != params.length) continue;
            return (G)grouping;
        }
        return null;
    }

    public static void printOptions(PrintStream out, String command, GroupedOptions ... groupings) {
        out.println();
        boolean firstRow = true;
        for (GroupedOptions grouping : groupings) {
            if (!firstRow) {
                out.println(" OR ");
            }
            firstRow = false;
            StringBuilder sb = new StringBuilder("Usage: ").append(command);
            for (Option option : grouping.options()) {
                sb.append(" ");
                sb.append(option.shortDisplay());
            }
            out.println(sb.toString());
        }
        out.println();
        HashSet<Option> printed = new HashSet<Option>();
        for (GroupedOptions grouping : groupings) {
            for (Option option : grouping.options()) {
                if (!printed.add(option) || option.longDisplay() == null) continue;
                out.println("  " + option.longDisplay());
                for (String row : option.multiLineDisplay()) {
                    out.println("      " + row);
                }
            }
        }
    }

    public String getOptionAsString() {
        StringBuilder sb = new StringBuilder();
        for (Option option : this.options()) {
            sb.append(option.getOptionAsString());
            sb.append("; ");
        }
        return sb.toString();
    }

    public static List<? extends Option> merge(List<? extends Option> ... optionss) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<? extends Option> options : optionss) {
            for (Option option : options) {
                if (!(option instanceof OptionSimple) || !((OptionSimple)option).isRequired()) continue;
                builder.add((Object)option);
            }
        }
        for (List<? extends Option> options : optionss) {
            for (Option option : options) {
                if (option instanceof OptionSimple && ((OptionSimple)option).isRequired()) continue;
                builder.add((Object)option);
            }
        }
        return builder.build();
    }

    static String formatLong(String longDisplay, String description) {
        return String.format("%-40s %s", longDisplay, description);
    }

    static String formatMultiLine(String longDisplay, String description) {
        return String.format("%-36s %s", longDisplay, description);
    }
}

