/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseArgumentsMissingException;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseCommandMissingException;
import io.airlift.airline.ParseCommandUnrecognizedException;
import io.airlift.airline.ParseOptionConversionException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import java.util.ArrayList;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.fqltool.commands.Compare;
import org.apache.cassandra.fqltool.commands.Dump;
import org.apache.cassandra.fqltool.commands.Replay;

public class FullQueryLogTool {
    public static void main(String ... args) {
        DatabaseDescriptor.clientInitialization();
        ArrayList commands = Lists.newArrayList((Object[])new Class[]{Help.class, Dump.class, Replay.class, Compare.class});
        Cli.CliBuilder builder = Cli.builder((String)"fqltool");
        builder.withDescription("Manipulate the contents of full query log files").withDefaultCommand(Help.class).withCommands((Iterable)commands);
        Cli parser = builder.build();
        int status = 0;
        try {
            ((Runnable)parser.parse(args)).run();
        }
        catch (ParseArgumentsMissingException | ParseArgumentsUnexpectedException | ParseCommandMissingException | ParseCommandUnrecognizedException | ParseOptionConversionException | ParseOptionMissingException | ParseOptionMissingValueException | IllegalArgumentException | IllegalStateException e) {
            FullQueryLogTool.badUse((Exception)e);
            status = 1;
        }
        catch (Throwable throwable) {
            FullQueryLogTool.err(Throwables.getRootCause((Throwable)throwable));
            status = 2;
        }
        System.exit(status);
    }

    private static void badUse(Exception e) {
        System.out.println("fqltool: " + e.getMessage());
        System.out.println("See 'fqltool help' or 'fqltool help <command>'.");
    }

    private static void err(Throwable e) {
        System.err.println("error: " + e.getMessage());
        System.err.println("-- StackTrace --");
        System.err.println(Throwables.getStackTraceAsString((Throwable)e));
    }
}

