package org.apache.cayenne.testdo.things.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.GenericPersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.things.Bag;
import org.apache.cayenne.testdo.things.Ball;
import org.apache.cayenne.testdo.things.Box;
import org.apache.cayenne.testdo.things.Thing;

/**
 * Class _Bag was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Bag extends GenericPersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Bag> SELF = PropertyFactory.createSelf(Bag.class);

    public static final NumericIdProperty<Long> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "Bag", Long.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final ListProperty<Ball> BALLS = PropertyFactory.createList("balls", Ball.class);
    public static final ListProperty<Box> BOXES = PropertyFactory.createList("boxes", Box.class);
    public static final ListProperty<Thing> THINGS = PropertyFactory.createList("things", Thing.class);

    protected String name;

    protected Object balls;
    protected Object boxes;
    protected Object things;

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void addToBalls(Ball obj) {
        addToManyTarget("balls", obj, true);
    }

    public void removeFromBalls(Ball obj) {
        removeToManyTarget("balls", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Ball> getBalls() {
        return (List<Ball>)readProperty("balls");
    }

    public void addToBoxes(Box obj) {
        addToManyTarget("boxes", obj, true);
    }

    public void removeFromBoxes(Box obj) {
        removeToManyTarget("boxes", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Box> getBoxes() {
        return (List<Box>)readProperty("boxes");
    }

    public void addToThings(Thing obj) {
        addToManyTarget("things", obj, true);
    }

    public void removeFromThings(Thing obj) {
        removeToManyTarget("things", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Thing> getThings() {
        return (List<Thing>)readProperty("things");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "name":
                return this.name;
            case "balls":
                return this.balls;
            case "boxes":
                return this.boxes;
            case "things":
                return this.things;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "name":
                this.name = (String)val;
                break;
            case "balls":
                this.balls = val;
                break;
            case "boxes":
                this.boxes = val;
                break;
            case "things":
                this.things = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.name);
        out.writeObject(this.balls);
        out.writeObject(this.boxes);
        out.writeObject(this.things);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.name = (String)in.readObject();
        this.balls = in.readObject();
        this.boxes = in.readObject();
        this.things = in.readObject();
    }

}
