/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.handler;

import org.apache.iotdb.db.utils.windowing.api.Evaluator;
import org.apache.iotdb.db.utils.windowing.configuration.SlidingSizeWindowConfiguration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.db.utils.windowing.handler.SlidingWindowEvaluationHandler;
import org.apache.iotdb.db.utils.windowing.runtime.WindowEvaluationTask;
import org.apache.iotdb.db.utils.windowing.window.WindowImpl;

public class SlidingSizeWindowEvaluationHandler
extends SlidingWindowEvaluationHandler {
    private final int windowSize;
    private final int slidingStep;
    private int nextTriggerPoint;

    public SlidingSizeWindowEvaluationHandler(SlidingSizeWindowConfiguration configuration, Evaluator evaluator) throws WindowingException {
        super(configuration, evaluator);
        this.windowSize = configuration.getWindowSize();
        this.slidingStep = configuration.getSlidingStep();
        this.nextTriggerPoint = this.windowSize;
    }

    @Override
    protected void createEvaluationTaskIfNecessary(long timestamp) {
        if (this.data.size() != this.nextTriggerPoint) {
            return;
        }
        TASK_POOL_MANAGER.submit(new WindowEvaluationTask(this.evaluator, new WindowImpl(this.data, this.nextTriggerPoint - this.windowSize, this.windowSize)));
        this.data.setEvictionUpperBound(this.nextTriggerPoint - this.windowSize + 1);
        this.nextTriggerPoint += this.slidingStep;
    }
}

