/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.ssl.HostPort;
import org.apache.commons.ssl.Ping;
import org.apache.commons.ssl.util.ByteArrayReadLine;

public class Util {
    public static final int SIZE_KEY = 0;
    public static final int LAST_READ_KEY = 1;

    public static boolean isYes(String yesString) {
        if (yesString == null) {
            return false;
        }
        String s = yesString.trim().toUpperCase();
        return "1".equals(s) || "YES".equals(s) || "TRUE".equals(s) || "ENABLE".equals(s) || "ENABLED".equals(s) || "Y".equals(s) || "ON".equals(s);
    }

    public static String trim(String s) {
        if (s == null || "".equals(s)) {
            return s;
        }
        int i = 0;
        int j = s.length() - 1;
        while (Util.isWhiteSpace(s.charAt(i))) {
            ++i;
        }
        while (Util.isWhiteSpace(s.charAt(j))) {
            --j;
        }
        return j >= i ? s.substring(i, j + 1) : "";
    }

    public static boolean isWhiteSpace(char c) {
        switch (c) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static void pipeStream(InputStream in, OutputStream out) throws IOException {
        Util.pipeStream(in, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeStream(InputStream in, OutputStream out, boolean autoClose) throws IOException {
        byte[] buf = new byte[8192];
        IOException ioe = null;
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                if (bytesRead > 0) {
                    out.write(buf, 0, bytesRead);
                }
                bytesRead = in.read(buf);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            if (autoClose) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        if (autoClose) {
            try {
                out.close();
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static byte[] streamToBytes(ByteArrayInputStream in, int maxLength) {
        byte[] buf = new byte[maxLength];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    public static byte[] streamToBytes(InputStream in, int maxLength) throws IOException {
        byte[] buf = new byte[maxLength];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int[] status = Util.fill(buf, 0, in);
            int size = status[0];
            int lastRead = status[1];
            while (lastRead != -1) {
                buf = Util.resizeArray(buf);
                status = Util.fill(buf, size, in);
                size = status[0];
                lastRead = status[1];
            }
            if (buf.length != size) {
                byte[] smallerBuf = new byte[size];
                System.arraycopy(buf, 0, smallerBuf, 0, size);
                buf = smallerBuf;
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    public static byte[] streamToBytes(ByteArrayInputStream in) {
        byte[] buf = new byte[4096];
        int[] status = Util.fill(buf, 0, in);
        int size = status[0];
        int lastRead = status[1];
        while (lastRead != -1) {
            buf = Util.resizeArray(buf);
            status = Util.fill(buf, size, in);
            size = status[0];
            lastRead = status[1];
        }
        if (buf.length != size) {
            byte[] smallerBuf = new byte[size];
            System.arraycopy(buf, 0, smallerBuf, 0, size);
            buf = smallerBuf;
        }
        return buf;
    }

    public static int[] fill(byte[] buf, int offset, InputStream in) throws IOException {
        int read;
        int lastRead = read = in.read(buf, offset, buf.length - offset);
        if (read == -1) {
            read = 0;
        }
        while (lastRead != -1 && read + offset < buf.length) {
            lastRead = in.read(buf, offset + read, buf.length - read - offset);
            if (lastRead == -1) continue;
            read += lastRead;
        }
        return new int[]{offset + read, lastRead};
    }

    public static int[] fill(byte[] buf, int offset, ByteArrayInputStream in) {
        int read;
        int lastRead = read = in.read(buf, offset, buf.length - offset);
        if (read == -1) {
            read = 0;
        }
        while (lastRead != -1 && read + offset < buf.length) {
            lastRead = in.read(buf, offset + read, buf.length - read - offset);
            if (lastRead == -1) continue;
            read += lastRead;
        }
        return new int[]{offset + read, lastRead};
    }

    public static byte[] resizeArray(byte[] bytes) {
        byte[] biggerBytes = new byte[bytes.length * 2];
        System.arraycopy(bytes, 0, biggerBytes, 0, bytes.length);
        return biggerBytes;
    }

    public static String pad(String s, int length, boolean left) {
        int diff;
        if (s == null) {
            s = "";
        }
        if ((diff = length - s.length()) == 0) {
            return s;
        }
        if (diff > 0) {
            int i;
            StringBuffer sb = new StringBuffer();
            if (left) {
                for (i = 0; i < diff; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(s);
            if (!left) {
                for (i = 0; i < diff; ++i) {
                    sb.append(' ');
                }
            }
            return sb.toString();
        }
        return s;
    }

    public static Map parseArgs(String[] cargs) {
        TreeMap<Ping.Arg, String[]> args = new TreeMap<Ping.Arg, String[]>();
        Map ARGS_MATCH = Ping.ARGS_MATCH;
        int l = cargs.length;
        String[] EMPTY_VALUES = new String[]{""};
        for (int i = 0; i < l; ++i) {
            String k = cargs[i];
            Ping.Arg a = (Ping.Arg)ARGS_MATCH.get(k);
            if (l > i + 1) {
                String v = cargs[++i];
                while (ARGS_MATCH.containsKey(v)) {
                    args.put(a, EMPTY_VALUES);
                    a = (Ping.Arg)ARGS_MATCH.get(v);
                    v = "";
                    if (l <= i + 1) continue;
                    v = cargs[++i];
                }
                String[] values = new String[]{v};
                args.put(a, values);
                if (l <= i + 1 || ARGS_MATCH.containsKey(cargs[i + 1])) continue;
                LinkedList<String> list = new LinkedList<String>();
                list.add(v);
                while (l > i + 1 && !ARGS_MATCH.containsKey(cargs[i + 1])) {
                    v = cargs[++i];
                    list.add(v);
                }
                args.put(a, list.toArray(new String[list.size()]));
                continue;
            }
            args.put(a, EMPTY_VALUES);
        }
        return args;
    }

    public static HostPort toAddress(String target, int defaultPort) throws UnknownHostException {
        String host = target;
        int port = defaultPort;
        StringTokenizer st = new StringTokenizer(target, ":");
        if (st.hasMoreTokens()) {
            host = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            port = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid host: " + target);
        }
        return new HostPort(host, port);
    }

    public static String cipherToAuthType(String cipher) {
        if (cipher == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(cipher.trim(), "_");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            String tok = st.nextToken();
            StringBuffer buf = new StringBuffer();
            buf.append(tok);
            if (st.hasMoreTokens()) {
                tok = st.nextToken();
                while (!"WITH".equalsIgnoreCase(tok)) {
                    buf.append('_');
                    buf.append(tok);
                    tok = st.nextToken();
                }
            }
            return buf.toString();
        }
        throw new IllegalArgumentException("not a valid cipher: " + cipher);
    }

    public static void main(String[] args) throws Exception {
        String s = "line1\n\rline2\n\rline3";
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        ByteArrayReadLine readLine = new ByteArrayReadLine(in);
        String line = readLine.next();
        while (line != null) {
            System.out.println(line);
            line = readLine.next();
        }
        System.out.println("--------- test 2 ----------");
        s = "line1\n\rline2\n\rline3\n\r\n\r";
        in = new ByteArrayInputStream(s.getBytes());
        readLine = new ByteArrayReadLine(in);
        line = readLine.next();
        while (line != null) {
            System.out.println(line);
            line = readLine.next();
        }
    }
}

