/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import java.util.List;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ProxyMatcher
implements Matcher,
Cloneable {
    private Matcher target;
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;
    private boolean memoMismatches;
    private boolean dirty;

    @Override
    public List<Matcher> getChildren() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getChildren();
    }

    public void setLabel(String string) {
        this.label = string;
        this.updateDirtyFlag();
    }

    private void setNodeSuppressed(boolean bl) {
        this.nodeSuppressed = bl;
        this.updateDirtyFlag();
    }

    private void setSubnodesSuppressed(boolean bl) {
        this.subnodesSuppressed = bl;
        this.updateDirtyFlag();
    }

    private void setNodeSkipped(boolean bl) {
        this.nodeSkipped = bl;
        this.updateDirtyFlag();
    }

    private void setMemoMismatches(boolean bl) {
        this.memoMismatches = bl;
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        this.dirty = this.label != null || this.nodeSuppressed || this.subnodesSuppressed || this.nodeSkipped || this.memoMismatches;
    }

    @Override
    public <V> boolean match(MatcherContext<V> matcherContext) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.match(matcherContext);
    }

    @Override
    public String getLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getLabel();
    }

    @Override
    public boolean hasCustomLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.hasCustomLabel();
    }

    @Override
    public boolean isNodeSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSuppressed();
    }

    @Override
    public boolean areSubnodesSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.areSubnodesSuppressed();
    }

    @Override
    public boolean isNodeSkipped() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSkipped();
    }

    @Override
    public boolean areMismatchesMemoed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.areMismatchesMemoed();
    }

    @Override
    public void setTag(Object object) {
        if (this.dirty) {
            this.apply();
        }
        this.target.setTag(object);
    }

    @Override
    public Object getTag() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getTag();
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        if (this.dirty) {
            this.apply();
        }
        return this.target.accept(matcherVisitor);
    }

    public String toString() {
        if (this.target == null) {
            return super.toString();
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.toString();
    }

    private void apply() {
        if (this.label != null) {
            this.label(this.label);
        }
        if (this.nodeSuppressed) {
            this.suppressNode();
        }
        if (this.subnodesSuppressed) {
            this.suppressSubnodes();
        }
        if (this.nodeSkipped) {
            this.skipNode();
        }
    }

    @Override
    public Rule label(String string) {
        if (this.target == null) {
            if (this.label == null) {
                this.setLabel(string);
                return this;
            }
            ProxyMatcher proxyMatcher = this.createClone();
            proxyMatcher.setLabel(string);
            proxyMatcher.arm(this);
            return proxyMatcher;
        }
        Matcher matcher = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)matcher.label(string);
        this.setLabel(null);
        return this.target;
    }

    @Override
    public Rule suppressNode() {
        if (this.target == null) {
            this.setNodeSuppressed(true);
            return this;
        }
        Matcher matcher = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)matcher.suppressNode();
        this.setNodeSuppressed(false);
        return this.target;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.target == null) {
            this.setSubnodesSuppressed(true);
            return this;
        }
        Matcher matcher = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)matcher.suppressSubnodes();
        this.setSubnodesSuppressed(false);
        return this.target;
    }

    @Override
    public Rule skipNode() {
        if (this.target == null) {
            this.setNodeSkipped(true);
            return this;
        }
        Matcher matcher = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)matcher.skipNode();
        this.setNodeSkipped(false);
        return this.target;
    }

    @Override
    public Rule memoMismatches() {
        if (this.target == null) {
            this.setMemoMismatches(true);
            return this;
        }
        Matcher matcher = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)matcher.memoMismatches();
        this.setMemoMismatches(false);
        return this.target;
    }

    public void arm(Matcher matcher) {
        this.target = Preconditions.checkArgNotNull(matcher, "target");
    }

    public static Matcher unwrap(Matcher matcher) {
        if (matcher instanceof ProxyMatcher) {
            ProxyMatcher proxyMatcher = (ProxyMatcher)matcher;
            if (proxyMatcher.dirty) {
                proxyMatcher.apply();
            }
            return proxyMatcher.target;
        }
        return matcher;
    }

    @Override
    public MatcherContext getSubContext(MatcherContext matcherContext) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getSubContext(matcherContext);
    }

    private ProxyMatcher createClone() {
        try {
            return (ProxyMatcher)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }
}

