/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.parboiled.Node;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Predicate;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.ParsingResult;

public abstract class ParboiledTest<V> {
    public TestResult<V> test(Rule rule, String string) {
        return new TestResult(new ReportingParseRunner(rule).run(string));
    }

    public TestResult<V> test(Rule rule, InputBuffer inputBuffer) {
        return new TestResult(new ReportingParseRunner(rule).run(inputBuffer));
    }

    public TestResult<V> testWithRecovery(Rule rule, String string) {
        return new TestResult(new RecoveringParseRunner(rule).run(string));
    }

    public TestResult<V> testWithRecovery(Rule rule, InputBuffer inputBuffer) {
        return new TestResult(new RecoveringParseRunner(rule).run(inputBuffer));
    }

    protected abstract void fail(String var1);

    protected abstract void assertEquals(Object var1, Object var2);

    public class TestResult<V> {
        public final ParsingResult<V> result;

        public TestResult(ParsingResult<V> parsingResult) {
            this.result = parsingResult;
        }

        public TestResult<V> hasNoErrors() {
            if (this.result.hasErrors()) {
                ParboiledTest.this.fail("\n--- ParseErrors ---\n" + ErrorUtils.printParseErrors(this.result) + "\n--- ParseTree ---\n" + ParseTreeUtils.printNodeTree(this.result));
            }
            return this;
        }

        public TestResult<V> hasErrors(String string) {
            ParboiledTest.this.assertEquals(ErrorUtils.printParseErrors(this.result), string);
            return this;
        }

        public TestResult<V> hasParseTree(String string) {
            ParboiledTest.this.assertEquals(ParseTreeUtils.printNodeTree(this.result), string);
            return this;
        }

        public TestResult<V> hasParseTree(Predicate<Node<V>> predicate, Predicate<Node<V>> predicate2, String string) {
            ParboiledTest.this.assertEquals(ParseTreeUtils.printNodeTree(this.result, predicate, predicate2), string);
            return this;
        }

        public TestResult<V> hasResult(V ... VArray) {
            ParboiledTest.this.assertEquals(this.toListReversed(this.result.valueStack), Arrays.asList(VArray));
            return this;
        }

        private <T> List<T> toListReversed(Iterable<T> iterable) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (T t : iterable) {
                arrayList.add(t);
            }
            Collections.reverse(arrayList);
            return arrayList;
        }
    }
}

