/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetrics;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.timeline.SnapshotRegistry;

public class GroupCoordinatorMetrics
extends CoordinatorMetrics
implements AutoCloseable {
    public static final String METRICS_GROUP = "group-coordinator-metrics";
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroups");
    public static final com.yammer.metrics.core.MetricName NUM_OFFSETS = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumOffsets");
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS_PREPARING_REBALANCE = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroupsPreparingRebalance");
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS_COMPLETING_REBALANCE = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroupsCompletingRebalance");
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS_STABLE = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroupsStable");
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS_DEAD = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroupsDead");
    public static final com.yammer.metrics.core.MetricName NUM_CLASSIC_GROUPS_EMPTY = GroupCoordinatorMetrics.getMetricName("GroupMetadataManager", "NumGroupsEmpty");
    public static final String GROUP_COUNT_METRIC_NAME = "group-count";
    public static final String GROUP_COUNT_PROTOCOL_TAG = "protocol";
    public static final String SHARE_GROUP_PROTOCOL_TAG = "protocol";
    public static final String CONSUMER_GROUP_COUNT_METRIC_NAME = "consumer-group-count";
    public static final String SHARE_GROUP_COUNT_METRIC_NAME = "group-count";
    public static final String CONSUMER_GROUP_COUNT_STATE_TAG = "state";
    public static final String SHARE_GROUP_COUNT_STATE_TAG = "state";
    public static final String OFFSET_COMMITS_SENSOR_NAME = "OffsetCommits";
    public static final String OFFSET_EXPIRED_SENSOR_NAME = "OffsetExpired";
    public static final String OFFSET_DELETIONS_SENSOR_NAME = "OffsetDeletions";
    public static final String CLASSIC_GROUP_COMPLETED_REBALANCES_SENSOR_NAME = "CompletedRebalances";
    public static final String CONSUMER_GROUP_REBALANCES_SENSOR_NAME = "ConsumerGroupRebalances";
    public static final String SHARE_GROUP_REBALANCES_SENSOR_NAME = "ShareGroupRebalances";
    private final MetricName classicGroupCountMetricName;
    private final MetricName consumerGroupCountMetricName;
    private final MetricName consumerGroupCountEmptyMetricName;
    private final MetricName consumerGroupCountAssigningMetricName;
    private final MetricName consumerGroupCountReconcilingMetricName;
    private final MetricName consumerGroupCountStableMetricName;
    private final MetricName consumerGroupCountDeadMetricName;
    private final MetricName shareGroupCountMetricName;
    private final MetricName shareGroupCountEmptyMetricName;
    private final MetricName shareGroupCountStableMetricName;
    private final MetricName shareGroupCountDeadMetricName;
    private final MetricsRegistry registry;
    private final Metrics metrics;
    private final Map<TopicPartition, GroupCoordinatorMetricsShard> shards = new ConcurrentHashMap<TopicPartition, GroupCoordinatorMetricsShard>();
    public final Map<String, Sensor> globalSensors;

    public GroupCoordinatorMetrics() {
        this(KafkaYammerMetrics.defaultRegistry(), new Metrics());
    }

    public GroupCoordinatorMetrics(MetricsRegistry registry, Metrics metrics) {
        this.registry = Objects.requireNonNull(registry);
        this.metrics = Objects.requireNonNull(metrics);
        this.classicGroupCountMetricName = metrics.metricName("group-count", METRICS_GROUP, "The total number of groups using the classic rebalance protocol.", Collections.singletonMap("protocol", Group.GroupType.CLASSIC.toString()));
        this.consumerGroupCountMetricName = metrics.metricName("group-count", METRICS_GROUP, "The total number of groups using the consumer rebalance protocol.", Collections.singletonMap("protocol", Group.GroupType.CONSUMER.toString()));
        this.consumerGroupCountEmptyMetricName = metrics.metricName(CONSUMER_GROUP_COUNT_METRIC_NAME, METRICS_GROUP, "The number of consumer groups in empty state.", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.EMPTY.toString()));
        this.consumerGroupCountAssigningMetricName = metrics.metricName(CONSUMER_GROUP_COUNT_METRIC_NAME, METRICS_GROUP, "The number of consumer groups in assigning state.", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()));
        this.consumerGroupCountReconcilingMetricName = metrics.metricName(CONSUMER_GROUP_COUNT_METRIC_NAME, METRICS_GROUP, "The number of consumer groups in reconciling state.", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.RECONCILING.toString()));
        this.consumerGroupCountStableMetricName = metrics.metricName(CONSUMER_GROUP_COUNT_METRIC_NAME, METRICS_GROUP, "The number of consumer groups in stable state.", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.STABLE.toString()));
        this.consumerGroupCountDeadMetricName = metrics.metricName(CONSUMER_GROUP_COUNT_METRIC_NAME, METRICS_GROUP, "The number of consumer groups in dead state.", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.DEAD.toString()));
        this.shareGroupCountMetricName = metrics.metricName("group-count", METRICS_GROUP, "The total number of share groups.", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString()));
        this.shareGroupCountEmptyMetricName = metrics.metricName("group-count", METRICS_GROUP, "The number of share groups in empty state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", ShareGroup.ShareGroupState.EMPTY.toString()});
        this.shareGroupCountStableMetricName = metrics.metricName("group-count", METRICS_GROUP, "The number of share groups in stable state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", ShareGroup.ShareGroupState.STABLE.toString()});
        this.shareGroupCountDeadMetricName = metrics.metricName("group-count", METRICS_GROUP, "The number of share groups in dead state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", ShareGroup.ShareGroupState.DEAD.toString()});
        this.registerGauges();
        Sensor offsetCommitsSensor = metrics.sensor(OFFSET_COMMITS_SENSOR_NAME);
        offsetCommitsSensor.add((CompoundStat)new Meter(metrics.metricName("offset-commit-rate", METRICS_GROUP, "The rate of committed offsets"), metrics.metricName("offset-commit-count", METRICS_GROUP, "The total number of committed offsets")));
        Sensor offsetExpiredSensor = metrics.sensor(OFFSET_EXPIRED_SENSOR_NAME);
        offsetExpiredSensor.add((CompoundStat)new Meter(metrics.metricName("offset-expiration-rate", METRICS_GROUP, "The rate of expired offsets"), metrics.metricName("offset-expiration-count", METRICS_GROUP, "The total number of expired offsets")));
        Sensor offsetDeletionsSensor = metrics.sensor(OFFSET_DELETIONS_SENSOR_NAME);
        offsetDeletionsSensor.add((CompoundStat)new Meter(metrics.metricName("offset-deletion-rate", METRICS_GROUP, "The rate of administrative deleted offsets"), metrics.metricName("offset-deletion-count", METRICS_GROUP, "The total number of administrative deleted offsets")));
        Sensor classicGroupCompletedRebalancesSensor = metrics.sensor(CLASSIC_GROUP_COMPLETED_REBALANCES_SENSOR_NAME);
        classicGroupCompletedRebalancesSensor.add((CompoundStat)new Meter(metrics.metricName("group-completed-rebalance-rate", METRICS_GROUP, "The rate of classic group completed rebalances"), metrics.metricName("group-completed-rebalance-count", METRICS_GROUP, "The total number of classic group completed rebalances")));
        Sensor consumerGroupRebalanceSensor = metrics.sensor(CONSUMER_GROUP_REBALANCES_SENSOR_NAME);
        consumerGroupRebalanceSensor.add((CompoundStat)new Meter(metrics.metricName("consumer-group-rebalance-rate", METRICS_GROUP, "The rate of consumer group rebalances"), metrics.metricName("consumer-group-rebalance-count", METRICS_GROUP, "The total number of consumer group rebalances")));
        Sensor shareGroupRebalanceSensor = metrics.sensor(SHARE_GROUP_REBALANCES_SENSOR_NAME);
        shareGroupRebalanceSensor.add((CompoundStat)new Meter(metrics.metricName("rebalance-rate", METRICS_GROUP, "The rate of share group rebalances", new String[]{"protocol", Group.GroupType.SHARE.toString()}), metrics.metricName("rebalance-count", METRICS_GROUP, "The total number of share group rebalances", new String[]{"protocol", Group.GroupType.SHARE.toString()})));
        this.globalSensors = Collections.unmodifiableMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)OFFSET_COMMITS_SENSOR_NAME, (Object)offsetCommitsSensor), Utils.mkEntry((Object)OFFSET_EXPIRED_SENSOR_NAME, (Object)offsetExpiredSensor), Utils.mkEntry((Object)OFFSET_DELETIONS_SENSOR_NAME, (Object)offsetDeletionsSensor), Utils.mkEntry((Object)CLASSIC_GROUP_COMPLETED_REBALANCES_SENSOR_NAME, (Object)classicGroupCompletedRebalancesSensor), Utils.mkEntry((Object)CONSUMER_GROUP_REBALANCES_SENSOR_NAME, (Object)consumerGroupRebalanceSensor), Utils.mkEntry((Object)SHARE_GROUP_REBALANCES_SENSOR_NAME, (Object)shareGroupRebalanceSensor)}));
    }

    private Long numOffsets() {
        return this.shards.values().stream().mapToLong(GroupCoordinatorMetricsShard::numOffsets).sum();
    }

    private Long numClassicGroups() {
        return this.shards.values().stream().mapToLong(GroupCoordinatorMetricsShard::numClassicGroups).sum();
    }

    private Long numClassicGroups(ClassicGroupState state) {
        return this.shards.values().stream().mapToLong(shard -> shard.numClassicGroups(state)).sum();
    }

    private long numConsumerGroups() {
        return this.shards.values().stream().mapToLong(GroupCoordinatorMetricsShard::numConsumerGroups).sum();
    }

    private long numConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        return this.shards.values().stream().mapToLong(shard -> shard.numConsumerGroups(state)).sum();
    }

    private long numShareGroups() {
        return this.shards.values().stream().mapToLong(GroupCoordinatorMetricsShard::numShareGroups).sum();
    }

    private long numShareGroups(ShareGroup.ShareGroupState state) {
        return this.shards.values().stream().mapToLong(shard -> shard.numShareGroups(state)).sum();
    }

    @Override
    public void close() {
        Arrays.asList(NUM_OFFSETS, NUM_CLASSIC_GROUPS, NUM_CLASSIC_GROUPS_PREPARING_REBALANCE, NUM_CLASSIC_GROUPS_COMPLETING_REBALANCE, NUM_CLASSIC_GROUPS_STABLE, NUM_CLASSIC_GROUPS_DEAD, NUM_CLASSIC_GROUPS_EMPTY).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        Arrays.asList(this.classicGroupCountMetricName, this.consumerGroupCountMetricName, this.consumerGroupCountEmptyMetricName, this.consumerGroupCountAssigningMetricName, this.consumerGroupCountReconcilingMetricName, this.consumerGroupCountStableMetricName, this.consumerGroupCountDeadMetricName, this.shareGroupCountMetricName, this.shareGroupCountEmptyMetricName, this.shareGroupCountStableMetricName, this.shareGroupCountDeadMetricName).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        Arrays.asList(OFFSET_COMMITS_SENSOR_NAME, OFFSET_EXPIRED_SENSOR_NAME, OFFSET_DELETIONS_SENSOR_NAME, CLASSIC_GROUP_COMPLETED_REBALANCES_SENSOR_NAME, CONSUMER_GROUP_REBALANCES_SENSOR_NAME, SHARE_GROUP_REBALANCES_SENSOR_NAME).forEach(arg_0 -> ((Metrics)this.metrics).removeSensor(arg_0));
    }

    public GroupCoordinatorMetricsShard newMetricsShard(SnapshotRegistry snapshotRegistry, TopicPartition tp) {
        return new GroupCoordinatorMetricsShard(snapshotRegistry, this.globalSensors, tp);
    }

    public void activateMetricsShard(CoordinatorMetricsShard shard) {
        if (!(shard instanceof GroupCoordinatorMetricsShard)) {
            throw new IllegalArgumentException("GroupCoordinatorMetrics can only activate GroupCoordinatorMetricShard");
        }
        this.shards.put(shard.topicPartition(), (GroupCoordinatorMetricsShard)shard);
    }

    public void deactivateMetricsShard(CoordinatorMetricsShard shard) {
        this.shards.remove(shard.topicPartition());
    }

    public MetricsRegistry registry() {
        return this.registry;
    }

    public void onUpdateLastCommittedOffset(TopicPartition tp, long offset) {
        CoordinatorMetricsShard shard = this.shards.get(tp);
        if (shard != null) {
            shard.commitUpTo(offset);
        }
    }

    public static com.yammer.metrics.core.MetricName getMetricName(String type, String name) {
        return GroupCoordinatorMetrics.getMetricName((String)"kafka.coordinator.group", (String)type, (String)name);
    }

    private void registerGauges() {
        this.registry.newGauge(NUM_OFFSETS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numOffsets();
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups();
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS_PREPARING_REBALANCE, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups(ClassicGroupState.PREPARING_REBALANCE);
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS_COMPLETING_REBALANCE, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups(ClassicGroupState.COMPLETING_REBALANCE);
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS_STABLE, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups(ClassicGroupState.STABLE);
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS_DEAD, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups(ClassicGroupState.DEAD);
            }
        });
        this.registry.newGauge(NUM_CLASSIC_GROUPS_EMPTY, (Gauge)new Gauge<Long>(){

            public Long value() {
                return GroupCoordinatorMetrics.this.numClassicGroups(ClassicGroupState.EMPTY);
            }
        });
        this.metrics.addMetric(this.classicGroupCountMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numClassicGroups()));
        this.metrics.addMetric(this.consumerGroupCountMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups()));
        this.metrics.addMetric(this.consumerGroupCountEmptyMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY)));
        this.metrics.addMetric(this.consumerGroupCountAssigningMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING)));
        this.metrics.addMetric(this.consumerGroupCountReconcilingMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING)));
        this.metrics.addMetric(this.consumerGroupCountStableMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE)));
        this.metrics.addMetric(this.consumerGroupCountDeadMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD)));
        this.metrics.addMetric(this.shareGroupCountMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numShareGroups()));
        this.metrics.addMetric(this.shareGroupCountEmptyMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numShareGroups(ShareGroup.ShareGroupState.EMPTY)));
        this.metrics.addMetric(this.shareGroupCountStableMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numShareGroups(ShareGroup.ShareGroupState.STABLE)));
        this.metrics.addMetric(this.shareGroupCountDeadMetricName, (MetricValueProvider)((org.apache.kafka.common.metrics.Gauge)(config, now) -> this.numShareGroups(ShareGroup.ShareGroupState.DEAD)));
    }
}

