/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.storage.internals.log.LeaderHwChange;

public class LogAppendInfo {
    public static final LogAppendInfo UNKNOWN_LOG_APPEND_INFO = new LogAppendInfo(-1L, -1L, OptionalInt.empty(), -1L, -1L, -1L, RecordValidationStats.EMPTY, CompressionType.NONE, -1, -1L);
    private long firstOffset;
    private long lastOffset;
    private long maxTimestamp;
    private long logAppendTime;
    private long logStartOffset;
    private RecordValidationStats recordValidationStats;
    private final OptionalInt lastLeaderEpoch;
    private final CompressionType sourceCompression;
    private final int validBytes;
    private final long lastOffsetOfFirstBatch;
    private final List<ProduceResponse.RecordError> recordErrors;
    private final LeaderHwChange leaderHwChange;

    public LogAppendInfo(long firstOffset, long lastOffset, OptionalInt lastLeaderEpoch, long maxTimestamp, long logAppendTime, long logStartOffset, RecordValidationStats recordValidationStats, CompressionType sourceCompression, int validBytes, long lastOffsetOfFirstBatch) {
        this(firstOffset, lastOffset, lastLeaderEpoch, maxTimestamp, logAppendTime, logStartOffset, recordValidationStats, sourceCompression, validBytes, lastOffsetOfFirstBatch, Collections.emptyList(), LeaderHwChange.NONE);
    }

    public LogAppendInfo(long firstOffset, long lastOffset, OptionalInt lastLeaderEpoch, long maxTimestamp, long logAppendTime, long logStartOffset, RecordValidationStats recordValidationStats, CompressionType sourceCompression, int validBytes, long lastOffsetOfFirstBatch, List<ProduceResponse.RecordError> recordErrors, LeaderHwChange leaderHwChange) {
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.lastLeaderEpoch = lastLeaderEpoch;
        this.maxTimestamp = maxTimestamp;
        this.logAppendTime = logAppendTime;
        this.logStartOffset = logStartOffset;
        this.recordValidationStats = recordValidationStats;
        this.sourceCompression = sourceCompression;
        this.validBytes = validBytes;
        this.lastOffsetOfFirstBatch = lastOffsetOfFirstBatch;
        this.recordErrors = recordErrors;
        this.leaderHwChange = leaderHwChange;
    }

    public long firstOffset() {
        return this.firstOffset;
    }

    public void setFirstOffset(long firstOffset) {
        this.firstOffset = firstOffset;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void setLastOffset(long lastOffset) {
        this.lastOffset = lastOffset;
    }

    public OptionalInt lastLeaderEpoch() {
        return this.lastLeaderEpoch;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public void setMaxTimestamp(long maxTimestamp) {
        this.maxTimestamp = maxTimestamp;
    }

    public long logAppendTime() {
        return this.logAppendTime;
    }

    public void setLogAppendTime(long logAppendTime) {
        this.logAppendTime = logAppendTime;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    public void setLogStartOffset(long logStartOffset) {
        this.logStartOffset = logStartOffset;
    }

    public RecordValidationStats recordValidationStats() {
        return this.recordValidationStats;
    }

    public void setRecordValidationStats(RecordValidationStats recordValidationStats) {
        this.recordValidationStats = recordValidationStats;
    }

    public CompressionType sourceCompression() {
        return this.sourceCompression;
    }

    public int validBytes() {
        return this.validBytes;
    }

    public List<ProduceResponse.RecordError> recordErrors() {
        return this.recordErrors;
    }

    public LeaderHwChange leaderHwChange() {
        return this.leaderHwChange;
    }

    public long firstOrLastOffsetOfFirstBatch() {
        return this.firstOffset >= 0L ? this.firstOffset : this.lastOffsetOfFirstBatch;
    }

    public long numMessages() {
        if (this.firstOffset >= 0L && this.lastOffset >= 0L) {
            return this.lastOffset - this.firstOffset + 1L;
        }
        return 0L;
    }

    public LogAppendInfo copy(LeaderHwChange newLeaderHwChange) {
        return new LogAppendInfo(this.firstOffset, this.lastOffset, this.lastLeaderEpoch, this.maxTimestamp, this.logAppendTime, this.logStartOffset, this.recordValidationStats, this.sourceCompression, this.validBytes, this.lastOffsetOfFirstBatch, this.recordErrors, newLeaderHwChange);
    }

    public static LogAppendInfo unknownLogAppendInfoWithLogStartOffset(long logStartOffset) {
        return new LogAppendInfo(-1L, -1L, OptionalInt.empty(), -1L, -1L, logStartOffset, RecordValidationStats.EMPTY, CompressionType.NONE, -1, -1L);
    }

    public static LogAppendInfo unknownLogAppendInfoWithAdditionalInfo(long logStartOffset, List<ProduceResponse.RecordError> recordErrors) {
        return new LogAppendInfo(-1L, -1L, OptionalInt.empty(), -1L, -1L, logStartOffset, RecordValidationStats.EMPTY, CompressionType.NONE, -1, -1L, recordErrors, LeaderHwChange.NONE);
    }

    public String toString() {
        return "LogAppendInfo(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", lastLeaderEpoch=" + String.valueOf(this.lastLeaderEpoch) + ", maxTimestamp=" + this.maxTimestamp + ", logAppendTime=" + this.logAppendTime + ", logStartOffset=" + this.logStartOffset + ", recordConversionStats=" + String.valueOf(this.recordValidationStats) + ", sourceCompression=" + String.valueOf(this.sourceCompression) + ", validBytes=" + this.validBytes + ", lastOffsetOfFirstBatch=" + this.lastOffsetOfFirstBatch + ", recordErrors=" + String.valueOf(this.recordErrors) + ", leaderHwChange=" + String.valueOf((Object)this.leaderHwChange) + ")";
    }
}

