/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareGroupCommandOptions
extends CommandDefaultOptions {
    public static final Logger LOGGER = LoggerFactory.getLogger(ShareGroupCommandOptions.class);
    public static final String BOOTSTRAP_SERVER_DOC = "REQUIRED: The server(s) to connect to.";
    public static final String GROUP_DOC = "The share group we wish to act on.";
    public static final String TOPIC_DOC = "The topic whose share group information should be deleted or topic whose should be included in the reset offset process. When resetting offsets, partitions can be specified using this format: 'topic1:0,1,2', where 0,1,2 are the partitions to be included.";
    public static final String ALL_TOPICS_DOC = "Consider all topics assigned to a share group in the 'reset-offsets' process.";
    public static final String LIST_DOC = "List all share groups.";
    public static final String DESCRIBE_DOC = "Describe share group, members and offset information.";
    public static final String NL = System.lineSeparator();
    public static final String DELETE_DOC = "Delete share group.";
    public static final String TIMEOUT_MS_DOC = "The timeout that can be set for some use cases. For example, it can be used when describing the group to specify the maximum amount of time in milliseconds to wait before the group stabilizes.";
    public static final String COMMAND_CONFIG_DOC = "Property file containing configs to be passed to Admin Client.";
    public static final String RESET_OFFSETS_DOC = "Reset offsets of share group. Supports one share group at the time, and instances must be inactive." + NL + "Has 2 execution options: --dry-run (the default) to plan which offsets to reset, and --execute to reset the offsets. " + NL + "You must choose one of the following reset specifications: --to-datetime, --to-earliest, --to-latest." + NL + "To define the scope use --all-topics or --topic.";
    public static final String DRY_RUN_DOC = "Only show results without executing changes on share groups. Supported operations: reset-offsets.";
    public static final String EXECUTE_DOC = "Execute operation. Supported operations: reset-offsets.";
    public static final String RESET_TO_DATETIME_DOC = "Reset offsets to offset from datetime. Format: 'YYYY-MM-DDTHH:mm:SS.sss'";
    public static final String RESET_TO_EARLIEST_DOC = "Reset offsets to earliest offset.";
    public static final String RESET_TO_LATEST_DOC = "Reset offsets to latest offset.";
    public static final String MEMBERS_DOC = "Describe members of the group. This option may be used with the '--describe' option only.";
    public static final String OFFSETS_DOC = "Describe the group and list all topic partitions in the group along with their offset information. This is the default sub-action and may be used with the '--describe' option only.";
    public static final String STATE_DOC = "When specified with '--describe', includes the state of the group." + NL + "When specified with '--list', it displays the state of all groups. It can also be used to list groups with specific states. Valid values are Empty, Stable and Dead.";
    public static final String DELETE_OFFSETS_DOC = "Delete offsets of share group. Supports one share group at the time, and multiple topics.";
    public final OptionSpec<String> bootstrapServerOpt;
    public final OptionSpec<String> groupOpt;
    public final OptionSpec<String> topicOpt;
    public final OptionSpec<Void> allTopicsOpt;
    public final OptionSpec<Void> listOpt;
    public final OptionSpec<Void> describeOpt;
    public final OptionSpec<Void> deleteOpt;
    public final OptionSpec<Long> timeoutMsOpt;
    public final OptionSpec<String> commandConfigOpt;
    public final OptionSpec<Void> resetOffsetsOpt;
    public final OptionSpec<Void> deleteOffsetsOpt;
    public final OptionSpec<Void> dryRunOpt;
    public final OptionSpec<Void> executeOpt;
    public final OptionSpec<String> resetToDatetimeOpt;
    public final OptionSpec<Void> resetToEarliestOpt;
    public final OptionSpec<Void> resetToLatestOpt;
    public final OptionSpec<Void> membersOpt;
    public final OptionSpec<Void> offsetsOpt;
    public final OptionSpec<String> stateOpt;
    public final Set<OptionSpec<?>> allShareGroupLevelOpts;
    public final Set<OptionSpec<?>> allResetOffsetScenarioOpts;
    public final Set<OptionSpec<?>> allDeleteOffsetsOpts;

    public ShareGroupCommandOptions(String[] args) {
        super(args);
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", BOOTSTRAP_SERVER_DOC).withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.groupOpt = this.parser.accepts("group", GROUP_DOC).withRequiredArg().describedAs("share group").ofType(String.class);
        this.topicOpt = this.parser.accepts("topic", TOPIC_DOC).withRequiredArg().describedAs("topic").ofType(String.class);
        this.allTopicsOpt = this.parser.accepts("all-topics", ALL_TOPICS_DOC);
        this.listOpt = this.parser.accepts("list", LIST_DOC);
        this.describeOpt = this.parser.accepts("describe", DESCRIBE_DOC);
        this.deleteOpt = this.parser.accepts("delete", DELETE_DOC);
        this.timeoutMsOpt = this.parser.accepts("timeout", TIMEOUT_MS_DOC).withRequiredArg().describedAs("timeout (ms)").ofType(Long.class).defaultsTo((Object)5000L, (Object[])new Long[0]);
        this.commandConfigOpt = this.parser.accepts("command-config", COMMAND_CONFIG_DOC).withRequiredArg().describedAs("command config property file").ofType(String.class);
        this.resetOffsetsOpt = this.parser.accepts("reset-offsets", RESET_OFFSETS_DOC);
        this.deleteOffsetsOpt = this.parser.accepts("delete-offsets", DELETE_OFFSETS_DOC);
        this.dryRunOpt = this.parser.accepts("dry-run", DRY_RUN_DOC);
        this.executeOpt = this.parser.accepts("execute", EXECUTE_DOC);
        this.resetToDatetimeOpt = this.parser.accepts("to-datetime", RESET_TO_DATETIME_DOC).withRequiredArg().describedAs("datetime").ofType(String.class);
        this.resetToEarliestOpt = this.parser.accepts("to-earliest", RESET_TO_EARLIEST_DOC);
        this.resetToLatestOpt = this.parser.accepts("to-latest", RESET_TO_LATEST_DOC);
        this.membersOpt = this.parser.accepts("members", MEMBERS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.offsetsOpt = this.parser.accepts("offsets", OFFSETS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.stateOpt = this.parser.accepts("state", STATE_DOC).availableIf(this.describeOpt, new OptionSpec[]{this.listOpt}).withOptionalArg().ofType(String.class);
        this.allShareGroupLevelOpts = new HashSet<OptionSpec>(Arrays.asList(this.listOpt, this.describeOpt, this.deleteOpt, this.resetOffsetsOpt));
        this.allResetOffsetScenarioOpts = new HashSet<OptionSpec>(Arrays.asList(this.resetToDatetimeOpt, this.resetToEarliestOpt, this.resetToLatestOpt));
        this.allDeleteOffsetsOpts = new HashSet<OptionSpec>(Arrays.asList(this.groupOpt, this.topicOpt));
        this.options = this.parser.parse(args);
    }

    public void checkArgs() {
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list, describe, reset and delete share groups.");
        CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
        if (this.options.has(this.describeOpt)) {
            List<OptionSpec> mutuallyExclusiveOpts;
            if (!this.options.has(this.groupOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes the option: " + String.valueOf(this.groupOpt)));
            }
            if ((mutuallyExclusiveOpts = Arrays.asList(this.membersOpt, this.offsetsOpt, this.stateOpt)).stream().mapToInt(o -> this.options.has(o) ? 1 : 0).sum() > 1) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes at most one of these options: " + mutuallyExclusiveOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            if (this.options.has(this.stateOpt) && this.options.valueOf(this.stateOpt) != null) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " does not take a value for " + String.valueOf(this.stateOpt)));
            }
        } else if (this.options.has(this.timeoutMsOpt)) {
            LOGGER.debug("Option " + String.valueOf(this.timeoutMsOpt) + " is applicable only when " + String.valueOf(this.describeOpt) + " is used.");
        }
        if (this.options.has(this.deleteOpt)) {
            if (!this.options.has(this.groupOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOpt) + " takes the option: " + String.valueOf(this.groupOpt)));
            }
            if (this.options.has(this.topicOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The consumer does not support topic-specific offset deletion from a share group.");
            }
        }
        if (!(!this.options.has(this.deleteOffsetsOpt) || this.options.has(this.groupOpt) && this.options.has(this.topicOpt))) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " takes the following options: " + this.allDeleteOffsetsOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        if (this.options.has(this.resetOffsetsOpt)) {
            if (this.options.has(this.dryRunOpt) && this.options.has(this.executeOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " only accepts one of " + String.valueOf(this.executeOpt) + " and " + String.valueOf(this.dryRunOpt)));
            }
            if (!this.options.has(this.dryRunOpt) && !this.options.has(this.executeOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " takes the option: " + String.valueOf(this.executeOpt) + " or " + String.valueOf(this.dryRunOpt)));
            }
            if (!this.options.has(this.groupOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " takes the option: " + String.valueOf(this.groupOpt)));
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToDatetimeOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToDatetimeOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToEarliestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToEarliestOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToLatestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToLatestOpt));
        }
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allShareGroupLevelOpts, this.describeOpt, this.deleteOpt, this.resetOffsetsOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.topicOpt, ToolsUtils.minus(this.allShareGroupLevelOpts, this.deleteOpt, this.resetOffsetsOpt));
    }
}

