/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

public final class ClassStack {
    private Class[] stack;
    private int pointer;

    public ClassStack(int initialCapacity) {
        this.stack = new Class[initialCapacity];
    }

    public void push(Class value) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = value;
    }

    public void popSilently() {
        --this.pointer;
    }

    public Class pop() {
        return this.stack[--this.pointer];
    }

    public Class peek() {
        return this.pointer == 0 ? null : this.stack[this.pointer - 1];
    }

    public int size() {
        return this.pointer;
    }

    public Class get(int i) {
        return this.stack[i];
    }

    private void resizeStack(int newCapacity) {
        Class[] newStack = new Class[newCapacity];
        System.arraycopy(this.stack, 0, newStack, 0, Math.min(this.stack.length, newCapacity));
        this.stack = newStack;
    }
}

