/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.icons;

import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;

public class LevelIconFactory {
    private static final LevelIconFactory instance = new LevelIconFactory();
    private final Map<String, Icon> iconMap = new HashMap<String, Icon>();

    private LevelIconFactory() {
        String[] iconFileNames = new String[]{"Warn.gif", "Inform.gif", "Error.gif", "Error.gif"};
        String[] iconLabels = new String[]{"WARN", "INFO", "ERROR", "FATAL"};
        for (int i = 0; i < iconLabels.length; ++i) {
            URL resourceURL = UIManager.getLookAndFeel().getClass().getResource("icons/" + iconFileNames[i]);
            if (resourceURL == null) {
                resourceURL = MetalLookAndFeel.class.getResource("icons/" + iconFileNames[i]);
            }
            if (resourceURL == null) {
                this.iconMap.put(iconLabels[i], ChainsawIcons.ICON_DEBUG);
                continue;
            }
            ImageIcon icon = new ImageIcon(resourceURL);
            double scalex = 0.5;
            double scaley = 0.5;
            int newWidth = (int)(scalex * (double)icon.getIconWidth());
            int newHeight = (int)(scaley * (double)icon.getIconHeight());
            Image iconImage = icon.getImage().getScaledInstance(newWidth, newHeight, 4);
            this.iconMap.put(iconLabels[i], new ImageIcon(iconImage));
        }
        this.iconMap.put("TRACE", ChainsawIcons.ICON_DEBUG);
        this.iconMap.put("DEBUG", ChainsawIcons.ICON_DEBUG);
    }

    public static final LevelIconFactory getInstance() {
        return instance;
    }

    public Map<String, Icon> getLevelToIconMap() {
        return this.iconMap;
    }
}

