/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;

public interface MonitorQuerySerializer {
    public MonitorQuery deserialize(BytesRef var1);

    public BytesRef serialize(MonitorQuery var1);

    public static MonitorQuerySerializer fromParser(final Function<String, Query> parser) {
        return new MonitorQuerySerializer(){

            @Override
            public MonitorQuery deserialize(BytesRef binaryValue) {
                MonitorQuery monitorQuery;
                ByteArrayInputStream is = new ByteArrayInputStream(binaryValue.bytes, binaryValue.offset, binaryValue.length);
                InputStreamDataInput data = new InputStreamDataInput((InputStream)is);
                try {
                    String id = data.readString();
                    String query = data.readString();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (int i = data.readInt(); i > 0; --i) {
                        metadata.put(data.readString(), data.readString());
                    }
                    monitorQuery = new MonitorQuery(id, (Query)parser.apply(query), query, metadata);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                data.close();
                return monitorQuery;
            }

            @Override
            public BytesRef serialize(MonitorQuery query) {
                BytesRef bytesRef;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                OutputStreamDataOutput data = new OutputStreamDataOutput((OutputStream)os);
                try {
                    data.writeString(query.getId());
                    data.writeString(query.getQueryString());
                    data.writeInt(query.getMetadata().size());
                    for (Map.Entry<String, String> entry : query.getMetadata().entrySet()) {
                        data.writeString(entry.getKey());
                        data.writeString(entry.getValue());
                    }
                    bytesRef = new BytesRef(os.toByteArray());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                data.close();
                return bytesRef;
            }
        };
    }
}

