/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAccumulatorAll is the corresponding interface of BACnetConstructedDataAccumulatorAll
type BACnetConstructedDataAccumulatorAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataAccumulatorAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAccumulatorAll()
	// CreateBuilder creates a BACnetConstructedDataAccumulatorAllBuilder
	CreateBACnetConstructedDataAccumulatorAllBuilder() BACnetConstructedDataAccumulatorAllBuilder
}

// _BACnetConstructedDataAccumulatorAll is the data-structure of this message
type _BACnetConstructedDataAccumulatorAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataAccumulatorAll = (*_BACnetConstructedDataAccumulatorAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAccumulatorAll)(nil)

// NewBACnetConstructedDataAccumulatorAll factory function for _BACnetConstructedDataAccumulatorAll
func NewBACnetConstructedDataAccumulatorAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAccumulatorAll {
	_result := &_BACnetConstructedDataAccumulatorAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAccumulatorAllBuilder is a builder for BACnetConstructedDataAccumulatorAll
type BACnetConstructedDataAccumulatorAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataAccumulatorAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAccumulatorAll or returns an error if something is wrong
	Build() (BACnetConstructedDataAccumulatorAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAccumulatorAll
}

// NewBACnetConstructedDataAccumulatorAllBuilder() creates a BACnetConstructedDataAccumulatorAllBuilder
func NewBACnetConstructedDataAccumulatorAllBuilder() BACnetConstructedDataAccumulatorAllBuilder {
	return &_BACnetConstructedDataAccumulatorAllBuilder{_BACnetConstructedDataAccumulatorAll: new(_BACnetConstructedDataAccumulatorAll)}
}

type _BACnetConstructedDataAccumulatorAllBuilder struct {
	*_BACnetConstructedDataAccumulatorAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAccumulatorAllBuilder) = (*_BACnetConstructedDataAccumulatorAllBuilder)(nil)

func (b *_BACnetConstructedDataAccumulatorAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAccumulatorAll
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) WithMandatoryFields() BACnetConstructedDataAccumulatorAllBuilder {
	return b
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) Build() (BACnetConstructedDataAccumulatorAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAccumulatorAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) MustBuild() BACnetConstructedDataAccumulatorAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAccumulatorAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAccumulatorAllBuilder().(*_BACnetConstructedDataAccumulatorAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAccumulatorAllBuilder creates a BACnetConstructedDataAccumulatorAllBuilder
func (b *_BACnetConstructedDataAccumulatorAll) CreateBACnetConstructedDataAccumulatorAllBuilder() BACnetConstructedDataAccumulatorAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataAccumulatorAllBuilder()
	}
	return &_BACnetConstructedDataAccumulatorAllBuilder{_BACnetConstructedDataAccumulatorAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAccumulatorAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_ACCUMULATOR
}

func (m *_BACnetConstructedDataAccumulatorAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAccumulatorAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAccumulatorAll(structType any) BACnetConstructedDataAccumulatorAll {
	if casted, ok := structType.(BACnetConstructedDataAccumulatorAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAccumulatorAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAccumulatorAll) GetTypeName() string {
	return "BACnetConstructedDataAccumulatorAll"
}

func (m *_BACnetConstructedDataAccumulatorAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataAccumulatorAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAccumulatorAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAccumulatorAll BACnetConstructedDataAccumulatorAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAccumulatorAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAccumulatorAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAccumulatorAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAccumulatorAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAccumulatorAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAccumulatorAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAccumulatorAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAccumulatorAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAccumulatorAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAccumulatorAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAccumulatorAll) IsBACnetConstructedDataAccumulatorAll() {}

func (m *_BACnetConstructedDataAccumulatorAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAccumulatorAll) deepCopy() *_BACnetConstructedDataAccumulatorAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAccumulatorAllCopy := &_BACnetConstructedDataAccumulatorAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataAccumulatorAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAccumulatorAllCopy
}

func (m *_BACnetConstructedDataAccumulatorAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
