/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCarPosition is the corresponding interface of BACnetConstructedDataCarPosition
type BACnetConstructedDataCarPosition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCarPosition returns CarPosition (property field)
	GetCarPosition() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataCarPosition is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCarPosition()
	// CreateBuilder creates a BACnetConstructedDataCarPositionBuilder
	CreateBACnetConstructedDataCarPositionBuilder() BACnetConstructedDataCarPositionBuilder
}

// _BACnetConstructedDataCarPosition is the data-structure of this message
type _BACnetConstructedDataCarPosition struct {
	BACnetConstructedDataContract
	CarPosition BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataCarPosition = (*_BACnetConstructedDataCarPosition)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCarPosition)(nil)

// NewBACnetConstructedDataCarPosition factory function for _BACnetConstructedDataCarPosition
func NewBACnetConstructedDataCarPosition(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, carPosition BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCarPosition {
	if carPosition == nil {
		panic("carPosition of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataCarPosition must not be nil")
	}
	_result := &_BACnetConstructedDataCarPosition{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CarPosition:                   carPosition,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCarPositionBuilder is a builder for BACnetConstructedDataCarPosition
type BACnetConstructedDataCarPositionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(carPosition BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCarPositionBuilder
	// WithCarPosition adds CarPosition (property field)
	WithCarPosition(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCarPositionBuilder
	// WithCarPositionBuilder adds CarPosition (property field) which is build by the builder
	WithCarPositionBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataCarPositionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCarPosition or returns an error if something is wrong
	Build() (BACnetConstructedDataCarPosition, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCarPosition
}

// NewBACnetConstructedDataCarPositionBuilder() creates a BACnetConstructedDataCarPositionBuilder
func NewBACnetConstructedDataCarPositionBuilder() BACnetConstructedDataCarPositionBuilder {
	return &_BACnetConstructedDataCarPositionBuilder{_BACnetConstructedDataCarPosition: new(_BACnetConstructedDataCarPosition)}
}

type _BACnetConstructedDataCarPositionBuilder struct {
	*_BACnetConstructedDataCarPosition

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCarPositionBuilder) = (*_BACnetConstructedDataCarPositionBuilder)(nil)

func (b *_BACnetConstructedDataCarPositionBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCarPosition
}

func (b *_BACnetConstructedDataCarPositionBuilder) WithMandatoryFields(carPosition BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCarPositionBuilder {
	return b.WithCarPosition(carPosition)
}

func (b *_BACnetConstructedDataCarPositionBuilder) WithCarPosition(carPosition BACnetApplicationTagUnsignedInteger) BACnetConstructedDataCarPositionBuilder {
	b.CarPosition = carPosition
	return b
}

func (b *_BACnetConstructedDataCarPositionBuilder) WithCarPositionBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataCarPositionBuilder {
	builder := builderSupplier(b.CarPosition.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.CarPosition, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCarPositionBuilder) Build() (BACnetConstructedDataCarPosition, error) {
	if b.CarPosition == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'carPosition' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCarPosition.deepCopy(), nil
}

func (b *_BACnetConstructedDataCarPositionBuilder) MustBuild() BACnetConstructedDataCarPosition {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCarPositionBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCarPositionBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCarPositionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCarPositionBuilder().(*_BACnetConstructedDataCarPositionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCarPositionBuilder creates a BACnetConstructedDataCarPositionBuilder
func (b *_BACnetConstructedDataCarPosition) CreateBACnetConstructedDataCarPositionBuilder() BACnetConstructedDataCarPositionBuilder {
	if b == nil {
		return NewBACnetConstructedDataCarPositionBuilder()
	}
	return &_BACnetConstructedDataCarPositionBuilder{_BACnetConstructedDataCarPosition: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCarPosition) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCarPosition) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CAR_POSITION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCarPosition) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCarPosition) GetCarPosition() BACnetApplicationTagUnsignedInteger {
	return m.CarPosition
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCarPosition) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetCarPosition())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCarPosition(structType any) BACnetConstructedDataCarPosition {
	if casted, ok := structType.(BACnetConstructedDataCarPosition); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCarPosition); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCarPosition) GetTypeName() string {
	return "BACnetConstructedDataCarPosition"
}

func (m *_BACnetConstructedDataCarPosition) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (carPosition)
	lengthInBits += m.CarPosition.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCarPosition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCarPosition) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCarPosition BACnetConstructedDataCarPosition, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCarPosition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCarPosition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	carPosition, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "carPosition", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'carPosition' field"))
	}
	m.CarPosition = carPosition

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), carPosition)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCarPosition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCarPosition")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCarPosition) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCarPosition) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCarPosition"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCarPosition")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "carPosition", m.GetCarPosition(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'carPosition' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCarPosition"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCarPosition")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCarPosition) IsBACnetConstructedDataCarPosition() {}

func (m *_BACnetConstructedDataCarPosition) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCarPosition) deepCopy() *_BACnetConstructedDataCarPosition {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCarPositionCopy := &_BACnetConstructedDataCarPosition{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.CarPosition),
	}
	_BACnetConstructedDataCarPositionCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCarPositionCopy
}

func (m *_BACnetConstructedDataCarPosition) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
