/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.netty;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferClosedException;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferReadOnlyException;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.ComponentIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferClosedException;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import org.apache.qpid.protonj2.buffer.ProtonBufferIterator;
import org.apache.qpid.protonj2.buffer.ProtonBufferUtils;
import org.apache.qpid.protonj2.buffer.netty.Netty5ProtonBufferAllocator;
import org.apache.qpid.protonj2.resource.SharedResource;

public final class Netty5ToProtonBufferAdapter
extends SharedResource<ProtonBuffer>
implements ProtonBuffer,
ProtonBufferComponentAccessor,
ProtonBufferComponent {
    private final Netty5ProtonBufferAllocator allocator;
    private static final Buffer CLOSED_BUFFER = BufferAllocator.onHeapUnpooled().allocate(0);
    private Buffer resource;
    private BufferComponent resourceComponent;

    public Netty5ToProtonBufferAdapter(Netty5ProtonBufferAllocator allocator, Buffer resource) {
        this.resource = resource;
        this.allocator = allocator;
        if (resource.countComponents() == 1 && resource instanceof BufferComponent) {
            this.resourceComponent = (BufferComponent)resource;
        }
    }

    public Netty5ProtonBufferAllocator allocator() {
        return this.allocator;
    }

    public Buffer unwrapAndRelease() {
        if (this.resource != CLOSED_BUFFER) {
            try {
                Buffer buffer = this.resource;
                return buffer;
            }
            finally {
                this.resource = CLOSED_BUFFER;
            }
        }
        throw new ProtonBufferClosedException("The buffer has already been closed or transferred");
    }

    public Buffer unwrap() {
        ProtonBufferUtils.checkIsClosed(this);
        return this.resource;
    }

    @Override
    public ProtonBuffer convertToReadOnly() {
        this.resource.makeReadOnly();
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.resource.readOnly();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int componentCount() {
        return this.resource.countComponents();
    }

    @Override
    public int readableComponentCount() {
        return this.resource.countReadableComponents();
    }

    @Override
    public int writableComponentCount() {
        return this.resource.countWritableComponents();
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int implicitGrowthLimit() {
        return this.resource.implicitCapacityLimit();
    }

    @Override
    public ProtonBuffer implicitGrowthLimit(int limit) {
        this.resource.implicitCapacityLimit(limit);
        return this;
    }

    @Override
    public ProtonBuffer fill(byte value) {
        try {
            this.resource.fill(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public int capacity() {
        return this.resource.capacity();
    }

    @Override
    public int getReadOffset() {
        return this.resource.readerOffset();
    }

    @Override
    public ProtonBuffer setReadOffset(int value) {
        this.resource.readerOffset(value);
        return this;
    }

    @Override
    public int getWriteOffset() {
        return this.resource.writerOffset();
    }

    @Override
    public ProtonBuffer setWriteOffset(int value) {
        try {
            this.resource.writerOffset(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer compact() {
        try {
            this.resource.compact();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public void copyInto(int offset, byte[] destination, int destOffset, int length) {
        try {
            this.resource.copyInto(offset, destination, destOffset, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public void copyInto(int offset, ByteBuffer destination, int destOffset, int length) {
        try {
            this.resource.copyInto(offset, destination, destOffset, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public void copyInto(int offset, ProtonBuffer destination, int destOffset, int length) {
        try {
            if (destination.unwrap() instanceof Buffer) {
                this.resource.copyInto(offset, (Buffer)destination.unwrap(), destOffset, length);
            } else {
                ProtonBufferUtils.checkIsReadOnly(destination);
                ProtonBufferUtils.checkIsClosed(this);
                while (length >= 8) {
                    destination.setLong(destOffset, this.getLong(offset));
                    length -= 8;
                    offset += 8;
                    destOffset += 8;
                }
                while (length >= 4) {
                    destination.setInt(destOffset, this.getInt(offset));
                    length -= 4;
                    offset += 4;
                    destOffset += 4;
                }
                while (length > 0) {
                    destination.setByte(destOffset, this.getByte(offset));
                    --length;
                    ++offset;
                    ++destOffset;
                }
            }
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source, int offset, int length) {
        try {
            this.resource.writeBytes(source, offset, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ByteBuffer source) {
        try {
            this.resource.writeBytes(source);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            this.resource.ensureWritable(size, minimumGrowth, allowCompaction);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length, boolean readOnly) throws IllegalArgumentException {
        try {
            return this.allocator.wrap(this.resource.copy(index, length, readOnly));
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public ProtonBuffer split(int splitOffset) {
        try {
            return this.allocator.wrap(this.resource.split(splitOffset));
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public String toString(Charset charset) {
        return this.resource.toString(charset);
    }

    public String toString() {
        return "Netty5ToProtonBufferAdapter{ read:" + (this.resource != null ? Integer.valueOf(this.resource.readerOffset()) : null) + ", write: " + (this.resource != null ? this.resource.writerOffset() : 0) + ", capacity: " + (this.resource != null ? this.resource.capacity() : 0) + "}";
    }

    @Override
    public int compareTo(ProtonBuffer buffer) {
        return ProtonBufferUtils.compare(this, buffer);
    }

    public boolean equals(Object other) {
        if (other instanceof ProtonBuffer) {
            return ProtonBufferUtils.equals(this, (ProtonBuffer)other);
        }
        return false;
    }

    public int hashCode() {
        return ProtonBufferUtils.hashCode(this);
    }

    @Override
    public byte getByte(int index) {
        try {
            return this.resource.getByte(index);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public char getChar(int index) {
        try {
            return this.resource.getChar(index);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public short getShort(int index) {
        try {
            return this.resource.getShort(index);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public int getInt(int index) {
        try {
            return this.resource.getInt(index);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public long getLong(int index) {
        try {
            return this.resource.getLong(index);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public ProtonBuffer setByte(int index, byte value) {
        try {
            this.resource.setByte(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, char value) {
        try {
            this.resource.setChar(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, short value) {
        try {
            this.resource.setShort(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        try {
            this.resource.setInt(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        try {
            this.resource.setLong(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public byte readByte() {
        try {
            return this.resource.readByte();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public char readChar() {
        try {
            return this.resource.readChar();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.resource.readShort();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.resource.readInt();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.resource.readLong();
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public ProtonBuffer writeByte(byte value) {
        try {
            this.resource.writeByte(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeChar(char value) {
        try {
            this.resource.writeChar(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        try {
            this.resource.writeShort(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        try {
            this.resource.writeInt(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        try {
            this.resource.writeLong(value);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
        return this;
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        try {
            return this.resource.transferTo(channel, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        try {
            return this.resource.transferFrom(channel, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        try {
            return this.resource.transferFrom(channel, position, length);
        }
        catch (RuntimeException e) {
            throw this.translateToProtonException(e);
        }
    }

    @Override
    public ProtonBufferComponentAccessor componentAccessor() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.resourceComponent != null) {
            return (ProtonBufferComponentAccessor)this.acquire();
        }
        return new ProtonNetty5BufferComponentAccessor((Netty5ToProtonBufferAdapter)this.acquire(), this.resource.forEachComponent());
    }

    @Override
    public ProtonBufferComponent first() {
        return this;
    }

    @Override
    public ProtonBufferComponent next() {
        return null;
    }

    @Override
    public int getReadableBytes() {
        return this.resourceComponent.readableBytes();
    }

    @Override
    public boolean hasReadbleArray() {
        return this.resourceComponent.hasReadableArray();
    }

    @Override
    public Netty5ToProtonBufferAdapter advanceReadOffset(int amount) {
        return (Netty5ToProtonBufferAdapter)ProtonBuffer.super.advanceReadOffset(amount);
    }

    @Override
    public byte[] getReadableArray() {
        return this.resourceComponent.readableArray();
    }

    @Override
    public int getReadableArrayOffset() {
        return this.resourceComponent.readableArrayOffset();
    }

    @Override
    public int getReadableArrayLength() {
        return this.resourceComponent.readableArrayLength();
    }

    @Override
    public ByteBuffer getReadableBuffer() {
        return this.resourceComponent.readableBuffer();
    }

    @Override
    public int getWritableBytes() {
        return this.resourceComponent.writableBytes();
    }

    @Override
    public Netty5ToProtonBufferAdapter advanceWriteOffset(int amount) {
        return (Netty5ToProtonBufferAdapter)ProtonBuffer.super.advanceWriteOffset(amount);
    }

    @Override
    public boolean hasWritableArray() {
        return this.resourceComponent.hasWritableArray();
    }

    @Override
    public byte[] getWritableArray() {
        return this.resourceComponent.writableArray();
    }

    @Override
    public int getWritableArrayOffset() {
        return this.resourceComponent.writableArrayOffset();
    }

    @Override
    public int getWritableArrayLength() {
        return this.resourceComponent.writableArrayLength();
    }

    @Override
    public ByteBuffer getWritableBuffer() {
        return this.resourceComponent.writableBuffer();
    }

    @Override
    public long getNativeAddress() {
        return this.resourceComponent.baseNativeAddress();
    }

    @Override
    public long getNativeReadAddress() {
        return this.resourceComponent.readableNativeAddress();
    }

    @Override
    public long getNativeWriteAddress() {
        return this.resourceComponent.writableNativeAddress();
    }

    @Override
    public ProtonBufferIterator bufferIterator() {
        return this.bufferIterator(this.getReadOffset(), this.getReadableBytes());
    }

    @Override
    public ProtonBufferIterator bufferIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "length");
        ProtonBufferUtils.checkIsNotNegative(offset, "length");
        if (offset + length > this.resource.capacity()) {
            throw new IndexOutOfBoundsException("The iterator cannot read beyond the bounds of the buffer: offset=" + offset + ", length=" + length);
        }
        return new Netty5ToProtonBufferReverseIterator(this.resource.openCursor(offset, length));
    }

    @Override
    public ProtonBufferIterator bufferReverseIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "length");
        ProtonBufferUtils.checkIsNotNegative(offset, "length");
        if (offset >= this.capacity()) {
            throw new IndexOutOfBoundsException("Read offset must be within the bounds of the buffer: offset = " + offset + ", capacity = " + this.capacity());
        }
        if (offset - length < -1) {
            throw new IndexOutOfBoundsException("Cannot read past start of buffer: offset = " + offset + ", length = " + length);
        }
        return new Netty5ToProtonBufferReverseIterator(this.resource.openReverseCursor(offset, length));
    }

    @Override
    public int indexOf(byte needle, int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        if (offset < this.getReadOffset() || this.getWriteOffset() < offset + length) {
            throw new IndexOutOfBoundsException("Cannot search past the readable bounds of this buffer");
        }
        int count = this.resource.bytesBefore(needle);
        if (count < 0) {
            return count;
        }
        int indexOf = offset + count;
        if (offset > indexOf || offset + length < indexOf) {
            return -1;
        }
        return indexOf;
    }

    @Override
    protected void releaseResourceOwnership() {
        if (this.resource != null && this.resource.isAccessible()) {
            this.resource.close();
            this.resource = CLOSED_BUFFER;
        }
    }

    @Override
    protected ProtonBuffer transferTheResource() {
        Buffer transferred = this.resource;
        this.resource = CLOSED_BUFFER;
        return new Netty5ToProtonBufferAdapter(this.allocator, transferred);
    }

    @Override
    protected RuntimeException resourceIsClosedException() {
        return ProtonBufferUtils.genericBufferIsClosed(this);
    }

    private RuntimeException translateToProtonException(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof BufferReadOnlyException) {
            result = ProtonBufferUtils.genericBufferIsReadOnly(this);
            result.addSuppressed(e);
        } else if (e instanceof BufferClosedException) {
            result = ProtonBufferUtils.genericBufferIsClosed(this);
            result.addSuppressed(e);
        }
        return result;
    }

    static {
        CLOSED_BUFFER.close();
    }

    private static final class ProtonNetty5BufferComponentAccessor
    implements ProtonBufferComponentAccessor,
    ProtonBufferComponent {
        private final Netty5ToProtonBufferAdapter adapter;
        private final ComponentIterator resourceIterator;
        private ComponentIterator.Next current;
        private BufferComponent currentComponent;

        public ProtonNetty5BufferComponentAccessor(Netty5ToProtonBufferAdapter adapter, ComponentIterator iterator) {
            this.adapter = adapter;
            this.resourceIterator = iterator;
        }

        @Override
        public void close() {
            this.current = null;
            this.currentComponent = null;
            this.resourceIterator.close();
            this.adapter.close();
        }

        @Override
        public ProtonBufferComponent first() {
            this.current = this.resourceIterator.first();
            this.currentComponent = (BufferComponent)this.current;
            return this;
        }

        @Override
        public ProtonBufferComponent next() {
            if (this.current != null) {
                this.current = this.current.next();
                this.currentComponent = (BufferComponent)this.current;
            }
            return this.current != null ? this : null;
        }

        @Override
        public Object unwrap() {
            return this.adapter.resource;
        }

        @Override
        public int getReadableBytes() {
            return this.currentComponent.readableBytes();
        }

        @Override
        public boolean hasReadbleArray() {
            return this.currentComponent.hasReadableArray();
        }

        @Override
        public ProtonBufferComponent advanceReadOffset(int amount) {
            this.currentComponent.skipReadableBytes(amount);
            return this;
        }

        @Override
        public byte[] getReadableArray() {
            return this.currentComponent.readableArray();
        }

        @Override
        public int getReadableArrayOffset() {
            return this.currentComponent.readableArrayOffset();
        }

        @Override
        public int getReadableArrayLength() {
            return this.currentComponent.readableArrayLength();
        }

        @Override
        public ByteBuffer getReadableBuffer() {
            return this.currentComponent.readableBuffer();
        }

        @Override
        public int getWritableBytes() {
            return this.currentComponent.writableBytes();
        }

        @Override
        public ProtonBufferComponent advanceWriteOffset(int amount) {
            this.currentComponent.skipWritableBytes(amount);
            return this;
        }

        @Override
        public boolean hasWritableArray() {
            return this.currentComponent.hasWritableArray();
        }

        @Override
        public byte[] getWritableArray() {
            return this.currentComponent.writableArray();
        }

        @Override
        public int getWritableArrayOffset() {
            return this.currentComponent.writableArrayOffset();
        }

        @Override
        public int getWritableArrayLength() {
            return this.currentComponent.writableArrayLength();
        }

        @Override
        public ByteBuffer getWritableBuffer() {
            return this.currentComponent.writableBuffer();
        }

        @Override
        public long getNativeAddress() {
            return this.currentComponent.baseNativeAddress();
        }

        @Override
        public long getNativeReadAddress() {
            return this.currentComponent.readableNativeAddress();
        }

        @Override
        public long getNativeWriteAddress() {
            return this.currentComponent.writableNativeAddress();
        }

        @Override
        public ProtonBufferIterator bufferIterator() {
            return new Netty5ToProtonBufferIterator(this.currentComponent.openCursor());
        }

        private final class Netty5ToProtonBufferIterator
        implements ProtonBufferIterator {
            private final ByteCursor cursor;

            public Netty5ToProtonBufferIterator(ByteCursor cursor) {
                this.cursor = cursor;
            }

            @Override
            public boolean hasNext() {
                return this.cursor.bytesLeft() > 0;
            }

            @Override
            public byte next() {
                if (this.cursor.readByte()) {
                    throw new NoSuchElementException("Cannot read outside the iterator bounds");
                }
                return this.cursor.getByte();
            }

            @Override
            public int remaining() {
                return this.cursor.bytesLeft();
            }

            @Override
            public int offset() {
                return this.cursor.currentOffset();
            }
        }
    }

    private static final class Netty5ToProtonBufferReverseIterator
    implements ProtonBufferIterator {
        private final ByteCursor cursor;

        public Netty5ToProtonBufferReverseIterator(ByteCursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.bytesLeft() > 0;
        }

        @Override
        public byte next() {
            if (!this.cursor.readByte()) {
                throw new NoSuchElementException("Cannot read outside the iterator bounds");
            }
            return this.cursor.getByte();
        }

        @Override
        public int remaining() {
            return this.cursor.bytesLeft();
        }

        @Override
        public int offset() {
            return this.cursor.currentOffset();
        }
    }
}

