/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTimeRangeChecker {
    private static final Logger LOG = LoggerFactory.getLogger(RangerTimeRangeChecker.class);
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT_2 = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd HH:mm"));
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd"));
    private static final ThreadLocal<DateFormat>[] DATE_FORMATS = new ThreadLocal[]{DATE_TIME_FORMAT, DATE_TIME_FORMAT_2, DATE_FORMAT};
    private final long fromTime;
    private final long toTime;

    public RangerTimeRangeChecker(String fromTime, String toTime, String timeZone) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTimeRangeChecker({}, {})", (Object)fromTime, (Object)toTime);
        }
        TimeZone tz = StringUtils.isNotBlank((String)timeZone) ? TimeZone.getTimeZone(timeZone) : null;
        this.fromTime = RangerTimeRangeChecker.parseDateTime(fromTime, tz);
        this.toTime = RangerTimeRangeChecker.parseDateTime(toTime, tz);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTimeRangeChecker({}, {}): fromTime={}, toTime={}", new Object[]{fromTime, toTime, this.fromTime, this.toTime});
        }
    }

    public boolean isInRange(long time) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isInRange({})", (Object)time);
        }
        if (this.toTime < 0L) {
            ret = time > this.fromTime;
        } else if (this.fromTime < 0L) {
            ret = time < this.toTime;
        } else {
            boolean bl = ret = time >= this.fromTime && time < this.toTime;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isInRange({}): fromTime={}, toTime={} ret={}", new Object[]{time, this.fromTime, this.toTime, ret});
        }
        return ret;
    }

    private static long parseDateTime(String str, TimeZone tz) {
        long ret;
        if (StringUtils.isNotBlank((String)str)) {
            Date date = null;
            ParseException excp = null;
            for (ThreadLocal<DateFormat> formatter : DATE_FORMATS) {
                try {
                    date = formatter.get().parse(str);
                    break;
                }
                catch (ParseException exception) {
                    excp = exception;
                }
            }
            if (date != null) {
                ret = tz != null ? RangerTimeRangeChecker.getAdjustedTime(date.getTime(), tz) : date.getTime();
            } else {
                LOG.error("Error parsing date:[{}]", (Object)str, excp);
                ret = -1L;
            }
        } else {
            ret = -1L;
        }
        return ret;
    }

    private static long getAdjustedTime(long localTime, TimeZone timeZone) {
        long ret;
        if (!DEFAULT_TIMEZONE.equals(timeZone)) {
            int targetOffset = timeZone.getOffset(localTime);
            int defaultOffset = DEFAULT_TIMEZONE.getOffset(localTime);
            int diff = defaultOffset - targetOffset;
            ret = localTime + (long)diff;
        } else {
            ret = localTime;
        }
        return ret;
    }
}

