/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.RegistrationInstance;
import org.apache.servicecomb.service.center.client.ServiceCenterRegistration;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;

public class SCRegistrationInstance
implements RegistrationInstance {
    private final Microservice microservice;
    private final MicroserviceInstance microserviceInstance;
    private final ServiceCenterRegistration serviceCenterRegistration;

    public SCRegistrationInstance(Microservice microservice, MicroserviceInstance microserviceInstance, ServiceCenterRegistration serviceCenterRegistration) {
        this.microservice = microservice;
        this.microserviceInstance = microserviceInstance;
        this.serviceCenterRegistration = serviceCenterRegistration;
    }

    public String getEnvironment() {
        return this.microservice.getEnvironment();
    }

    public String getApplication() {
        return this.microservice.getAppId();
    }

    public String getServiceName() {
        return this.microservice.getServiceName();
    }

    public String getAlias() {
        return this.microservice.getAlias();
    }

    public String getVersion() {
        return this.microservice.getVersion();
    }

    public DataCenterInfo getDataCenterInfo() {
        return new DataCenterInfo(this.microserviceInstance.getDataCenterInfo().getName(), this.microserviceInstance.getDataCenterInfo().getRegion(), this.microserviceInstance.getDataCenterInfo().getAvailableZone());
    }

    public String getDescription() {
        return this.microservice.getDescription();
    }

    public Map<String, String> getProperties() {
        return this.microserviceInstance.getProperties();
    }

    public Map<String, String> getSchemas() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.serviceCenterRegistration.getSchemaInfos().forEach(info -> result.put(info.getSchemaId(), info.getSchema()));
        return result;
    }

    public List<String> getEndpoints() {
        return this.microserviceInstance.getEndpoints();
    }

    public String getInstanceId() {
        return this.microserviceInstance.getInstanceId();
    }

    public String getServiceId() {
        return this.microservice.getServiceId();
    }

    public MicroserviceInstanceStatus getStatus() {
        return MicroserviceInstanceStatus.valueOf((String)this.microserviceInstance.getStatus().name());
    }

    public Microservice getBackendMicroservice() {
        return this.microservice;
    }

    public MicroserviceInstance getBackendMicroserviceInstance() {
        return this.microserviceInstance;
    }
}

