/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIteratorInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceIteratorInputStream.class);
    private int n;
    private InputStream currentStream;
    private final Iterator<Resource> iterator;
    private int streamNo = 0;

    public ResourceIteratorInputStream(Iterator<Resource> iterator) {
        this.iterator = iterator;
        while (iterator.hasNext()) {
            this.currentStream = (InputStream)iterator.next().adaptTo(InputStream.class);
            if (this.currentStream == null) continue;
            this.n = 0;
            this.streamNo = 1;
            return;
        }
        throw new IllegalArgumentException("Resource iterator does not contain any resources that can be adapted to an input stream.");
    }

    @Override
    public int read() throws IOException {
        int i = this.currentStream.read();
        while (i == -1) {
            if (this.iterator.hasNext()) {
                LOGGER.debug("Stream {} provided {} bytes. ", (Object)this.streamNo, (Object)this.n);
                this.currentStream = (InputStream)this.iterator.next().adaptTo(InputStream.class);
                ++this.streamNo;
                this.n = 0;
                if (this.currentStream == null) continue;
                i = this.currentStream.read();
                continue;
            }
            LOGGER.debug("Last Stream {} provided {} bytes. ", (Object)this.streamNo, (Object)this.n);
            return -1;
        }
        ++this.n;
        return i;
    }
}

