/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.util.Validate;

@FunctionalInterface
public interface AnnotationBehaviorMergeStrategy
extends Function<Iterable<? extends HasAnnotationBehavior>, AnnotationBehavior> {
    public static AnnotationBehaviorMergeStrategy first() {
        return coll -> {
            Iterator iterator = coll.iterator();
            return iterator.hasNext() ? ((HasAnnotationBehavior)iterator.next()).getAnnotationBehavior() : AnnotationBehavior.ABSTAIN;
        };
    }

    public static AnnotationBehaviorMergeStrategy consensus() {
        return coll -> {
            Stream.Builder b = Stream.builder();
            coll.forEach(b);
            Set annotationBehaviors = b.build().map(HasAnnotationBehavior::getAnnotationBehavior).filter(Objects::nonNull).filter(Predicate.isEqual(AnnotationBehavior.ABSTAIN).negate()).collect(Collectors.toCollection(() -> EnumSet.noneOf(AnnotationBehavior.class)));
            Validate.validState(annotationBehaviors.size() <= 1, "Conflicting annotation inclusion behaviors found among %s", coll);
            return annotationBehaviors.isEmpty() ? AnnotationBehavior.ABSTAIN : (AnnotationBehavior)annotationBehaviors.iterator().next();
        };
    }
}

