/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodSpec
implements Comparable,
Serializable {
    private static final long serialVersionUID = -1623511701541770312L;
    private static final int AFTER_OTHER = 1;
    private static final int BEFORE_OTHER = -1;
    private final String methodIntf;
    private final String methodName;
    private final String[] parameterTypes;

    public MethodSpec(String methodIntf, String methodName, String[] parameterTypes) {
        this.methodIntf = methodIntf;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public MethodSpec(String text) {
        Pattern p = Pattern.compile("(\\S+) (\\S+)\\((\\S*)\\)");
        Matcher m = p.matcher(text);
        if (!m.matches()) {
            throw new IllegalArgumentException("Text must match (\\S+) (\\S+)\\((\\S*)\\) : " + text);
        }
        String intfString = m.group(1);
        this.methodIntf = intfString.equals("all") ? null : intfString;
        this.methodName = m.group(2);
        String parameters = m.group(3);
        this.parameterTypes = parameters.length() > 0 ? parameters.split(" *, *") : null;
    }

    public String getMethodIntf() {
        return this.methodIntf;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.methodIntf.hashCode();
        result = 37 * result + this.methodName.hashCode();
        for (String parameterType : this.parameterTypes) {
            result = 37 * result + parameterType.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodSpec)) {
            return false;
        }
        MethodSpec methodSpec = (MethodSpec)obj;
        return this.methodIntf.equals(methodSpec.methodIntf) && this.methodName.equals(methodSpec.methodName) && Arrays.equals(this.parameterTypes, methodSpec.parameterTypes);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.methodIntf != null) {
            buffer.append(this.methodIntf);
        } else {
            buffer.append("all");
        }
        buffer.append(" ").append(this.methodName).append('(');
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                String parameterType = this.parameterTypes[i];
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(parameterType);
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean matches(String methodIntf, String methodName, String[] parameterTypes) {
        assert (methodIntf != null);
        assert (methodName != null);
        assert (parameterTypes != null);
        if (this.methodIntf != null && !methodIntf.equals(this.methodIntf)) {
            return false;
        }
        if (this.methodName.equals("*")) {
            return true;
        }
        if (!methodName.equals(this.methodName)) {
            return false;
        }
        if (this.parameterTypes == null) {
            return true;
        }
        return Arrays.equals(parameterTypes, this.parameterTypes);
    }

    public int compareTo(Object o) {
        if (!(o instanceof MethodSpec)) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        MethodSpec other = (MethodSpec)o;
        if (this.parameterTypes != null) {
            if (other.parameterTypes == null) {
                return -1;
            }
            if (this.methodIntf != null) {
                if (other.methodIntf == null) {
                    return -1;
                }
                int intfOrder = this.methodIntf.compareTo(other.methodIntf);
                if (intfOrder != 0) {
                    return intfOrder;
                }
                return this.compareMethod(other);
            }
            if (other.methodIntf != null) {
                return 1;
            }
            return this.compareMethod(other);
        }
        if (other.parameterTypes != null) {
            return 1;
        }
        if (!this.methodName.equals("*")) {
            if (other.methodName.equals("*")) {
                return -1;
            }
            if (this.methodIntf != null) {
                if (other.methodIntf == null) {
                    return -1;
                }
                int intfOrder = this.methodIntf.compareTo(other.methodIntf);
                if (intfOrder != 0) {
                    return intfOrder;
                }
                return this.methodName.compareTo(other.methodName);
            }
            if (other.methodIntf != null) {
                return 1;
            }
            return this.methodName.compareTo(other.methodName);
        }
        if (!other.methodName.equals("*")) {
            return 1;
        }
        if (this.methodIntf != null) {
            if (other.methodIntf == null) {
                return -1;
            }
            return this.methodIntf.compareTo(other.methodIntf);
        }
        if (other.methodIntf != null) {
            return 1;
        }
        throw new IllegalStateException("Cannot compare " + String.valueOf(this) + " and " + String.valueOf(other));
    }

    private int compareMethod(MethodSpec other) {
        int methodOrder = this.methodName.compareTo(other.methodName);
        if (methodOrder != 0) {
            return methodOrder;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i == other.parameterTypes.length) {
                return 1;
            }
            int paramOrder = this.parameterTypes[i].compareTo(other.parameterTypes[i]);
            if (paramOrder == 0) continue;
            return paramOrder;
        }
        return -1;
    }
}

