@echo off
echo Configuring GNU dbm 1.13 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set COMPAT=enabled
if not "%COMPAT%" == "enabled" goto SmallEnv
set EXPORT=enabled
if not "%EXPORT%" == "enabled" goto SmallEnv
set MMIO=disabled
if not "%MMIO%" == "disabled" goto SmallEnv
set READLINE=disabled
if not "%READLINE%" == "disabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto SilentOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto CompatOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:CompatOption
if "%1" == "compat" goto NextArgument
if "%1" == "COMPAT" goto NextArgument
if "%1" == "no-compat" goto NoCOMPAT
if "%1" == "no-COMPAT" goto NoCOMPAT
if "%1" == "NO-COMPAT" goto NoCOMPAT
goto ExportOption
:NoCOMPAT
if "%1" == "no-compat" set COMPAT=disabled
if "%1" == "no-COMPAT" set COMPAT=disabled
if "%1" == "NO-COMPAT" set COMPAT=disabled
if not "%COMPAT%" == "disabled" goto SmallEnv
goto NextArgument
:ExportOption
if "%1" == "export" goto NextArgument
if "%1" == "EXPORT" goto NextArgument
if "%1" == "no-export" goto NoEXPORT
if "%1" == "no-EXPORT" goto NoEXPORT
if "%1" == "NO-EXPORT" goto NoEXPORT
goto MmioOption
:NoEXPORT
if "%1" == "no-export" set EXPORT=disabled
if "%1" == "no-EXPORT" set EXPORT=disabled
if "%1" == "NO-EXPORT" set EXPORT=disabled
if not "%EXPORT%" == "disabled" goto SmallEnv
goto NextArgument
:MmioOption
if "%1" == "no-mmio" goto NextArgument
if "%1" == "no-MMIO" goto NextArgument
if "%1" == "NO-MMIO" goto NextArgument
if "%1" == "mmio" goto _MMIO
if "%1" == "Mmio" goto _MMIO
if "%1" == "MMIO" goto _MMIO
goto ReadlineOption
:_MMIO
if "%1" == "mmio" set MMIO=enabled
if "%1" == "Mmio" set MMIO=enabled
if "%1" == "MMIO" set MMIO=enabled
if not "%MMIO%" == "enabled" goto SmallEnv
goto NextArgument
:ReadlineOption
if "%1" == "no-readline" goto NextArgument
if "%1" == "no-READLINE" goto NextArgument
if "%1" == "NO-READLINE" goto NextArgument
if "%1" == "readline" goto _READLINE
if "%1" == "Readline" goto _READLINE
if "%1" == "READLINE" goto _READLINE
goto SrcDirOption
:_READLINE
if "%1" == "readline" set READLINE=enabled
if "%1" == "Readline" set READLINE=enabled
if "%1" == "READLINE" set READLINE=enabled
if not "%READLINE%" == "enabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"                   echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"                   echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"       echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled"      echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"           echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"          echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"            echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"           echo --without-libintl-prefix >> args
if "%SILENT%" == "enabled"                    echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"                   echo --disable-silent-rules >> args
if "%COMPAT%" == "enabled"                    echo --enable-libgdbm-compat >> args
if "%COMPAT%" == "disabled"                   echo --disable-libgdbm-compat >> args
if "%EXPORT%" == "enabled"                    echo --enable-gdbm-export >> args
if "%EXPORT%" == "disabled"                   echo --disable-gdbm-export >> args
if "%MMIO%" == "enabled"                      echo --enable-memory-mapped-io >> args
if "%MMIO%" == "disabled"                     echo --disable-memory-mapped-io >> args
if "%ARGS%" == "" if "%EXPORT%" == "enabled"  echo --with-gdbm183-library=-lgdbm >> args
if "%READLINE%" == "enabled"                  echo --with-readline >> args
if "%READLINE%" == "disabled"                 echo --without-readline >> args
if not "%ARGS%" == ""                         echo %ARGS% >> args
echo --prefix=/dev/env/DJDIR >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set SILENT=
set COMPAT=
set EXPORT=
set MMIO=
set READLINE=


if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/autoconf.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/autoconf.h.in %XSRC%/autoconf.h-in
test -f %XSRC%/autoconf.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/autoconf.h %XSRC%/autoconf.h-in
test -f %XSRC%/autoconf.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/autoconfh.in %XSRC%/autoconf.h-in
test -f %XSRC%/autoconf.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/autoconf_h.in %XSRC%/autoconf.h-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/src/gdbm.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/gdbm.h.in %XSRC%/src/gdbm.h-in
test -f %XSRC%/src/gdbm.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/gdbm.h %XSRC%/src/gdbm.h-in
test -f %XSRC%/src/gdbm.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/gdbmh.in %XSRC%/src/gdbm.h-in
test -f %XSRC%/src/gdbm.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/src/gdbm_h.in %XSRC%/src/gdbm.h-in
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/gdbm.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/gdbm..in %XSRC%/man/gdbm.-in
:test -f %XSRC%/man/gdbm.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/gdbm. %XSRC%/man/gdbm.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem Update libtool files
echo Updating libtool scripts...
test -f %XSRC%/build-aux/ltmain.org
if errorlevel 1 update %XSRC%/build-aux/ltmain.sh %XSRC%/build-aux/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/build-aux/ltmain.org > ltmain.tmp
if errorlevel 1 goto Sed8Error
dtou ltmain.tmp
mv -f ltmain.tmp %XSRC%/build-aux/ltmain.sh

Rem Editing autoconf.h-in...
echo Editing autoconf.h-in...
test -f %XSRC%/autoconf.in-org
if errorlevel 1 update %XSRC%/autoconf.h-in %XSRC%/autoconf.in-org
sed "$ a\\n\/* Define to 1 if you have the <arpa/inet.h> header file. */\n\#undef HAVE_ARPA_INET_H" %XSRC%/autoconf.in-org > autoconf.tmp
if errorlevel 1 goto Sed9Error
dtou ./autoconf.tmp
:touch -r %XSRC%/autoconf.in-org ./autoconf.tmp
mv -f ./autoconf.tmp %XSRC%/autoconf.h-in

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/gdbm.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
echo Editing autoconf.h...
sed -f %XSRC%/djgpp/config_h.sed ./autoconf.h > autoconf.tmp
if errorlevel 1 goto Sed2Error
dtou ./autoconf.tmp
mv -f ./autoconf.tmp ./autoconf.h
echo Done.

echo Editing tests/testsuite...
test -f %XSRC%/tests/testsuite.org
if errorlevel 1 update %XSRC%/tests/testsuite %XSRC%/tests/testsuite.org
sed -f %XSRC%/djgpp/testsuite.sed %XSRC%/tests/testsuite.org > testsuite.tst
if errorlevel 1 goto Sed4Error
dtou ./testsuite.tst
mv testsuite.tst %XSRC%/tests/testsuite
echo Done.

echo Editing tests/Makefile...
sed -f %XSRC%/djgpp/Makefile.sed ./tests/Makefile > Makefile.tst
if errorlevel 1 goto Sed5Error
dtou ./Makefile.tst
mv Makefile.tst ./tests/Makefile
echo Done.

echo Editing src/Makefile...
sed "/^VPATH[ 	]*=/ s|$|;$(top_srcdir)/djgpp|;/^DEFAULT_INCLUDES[ 	]*=/ s|$| -I$(top_srcdir)|" ./src/Makefile > Makefile.src
if errorlevel 1 goto Sed6Error
dtou ./Makefile.src
mv Makefile.src ./src/Makefile
echo Done.

echo Editing export/Makefile...
sed "/^LIBS[ 	]*=/ s|$|$(INTLLIBS)|" ./export/Makefile > Makefile.exp
if errorlevel 1 goto Sed6Error
dtou ./Makefile.exp
mv Makefile.exp ./export/Makefile
echo Done.
goto End


:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo autoconf.h fixing failed!
goto End

:Sed4Error
echo tests/testsuite fixing failed!
goto End

:Sed5Error
echo tests/Makefile fixing failed!
goto End

:Sed6Error
echo src/Makefile fixing failed!
goto End

:Sed7Error
echo export/Makefile fixing failed!
goto End

:Sed8Error
echo ./ltmain.sh editing failed!
goto End

:Sed9Error
echo ./autoconf.h-in editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set COMPAT=
set EXPORT=
set MMIO=
set READLINE=
set XSRC=
