"======================================================================
|
|   ServerSocket wrapper class
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


AbstractSocket subclass: #ServerSocket
	  instanceVariableNames: ''
	  classVariableNames: ''
	  poolDictionaries: ''
	  category: 'Sockets-Streams'
!

!ServerSocket class methodsFor: 'instance creation'!

initialize
    ServerSocket defaultImplementationClass: TCPSocketImpl
! !

!ServerSocket class methodsFor: 'instance creation'!

defaultQueueSize
    ^50
!

queueSize: backlog
    ^self
        port: 0
        queueSize:
        backlog bindTo: IPAddress unknownAddress
!

queueSize: backlog bindTo: ipAddress
    ^self
        port: 0
        queueSize: backlog
        bindTo: ipAddress
!

port: anInteger
    ^self
        port: anInteger
        queueSize: self defaultQueueSize
        bindTo: IPAddress unknownAddress
!

port: anInteger queueSize: backlog
    ^self
        port: anInteger
        queueSize: backlog
        bindTo: IPAddress unknownAddress
!

port: anInteger bindTo: ipAddress
    ^self
        port: anInteger
        queueSize: self defaultQueueSize
        bindTo: ipAddress
!

port: anInteger queueSize: backlog bindTo: ipAddress
    (anInteger < 0) | (anInteger > 16rFFFF)
	ifTrue: [ self error: 'port out of range' ].

    ^self new
	port: anInteger queueSize: backlog bindTo: ipAddress
! !

!ServerSocket methodsFor: 'accessing'!

address
    ^self localAddress
!

port
    ^self localPort
!

accept
    self available ifFalse: [ ^nil ].	"Make it non-blocking"
    ^self primAccept: Socket
!

accept: socketClass
    self available ifFalse: [ ^nil ].	"Make it non-blocking"
    ^self primAccept: socketClass
!

primAccept: socketClass
    | implClass newImpl |
    implClass := socketClass defaultImplementationClass.
    newImpl := self implementation accept: implClass.
    ^socketClass new: newImpl
! !

!ServerSocket methodsFor: 'private'!

port: anInteger queueSize: backlog bindTo: ipAddress

    | ipAddressToBindTo |
    ipAddressToBindTo := ipAddress isNil
	ifTrue: [ ipAddress ]
	ifFalse: [ IPAddress unknownAddress ].

    self implementation
	create;
	bindTo: ipAddressToBindTo port: anInteger;
	listen: backlog
! !
