/* RCS soft links support */

/****************************************************************************
 *                     following link paths stored in files called `rcs'
 ****************************************************************************
 */

/* Copyright (c) 1995 Marc Singer
   Distributed under license by the Free Software Foundation, Inc.

This file should be part of RCS.

RCS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

RCS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RCS; see the file COPYING.
If not, write to the Free Software Foundation,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Report problems and questions for this file to:

    elf@netcom.com

*/

/*
 * $Log: rcslinks.c,v $
 * Revision 1.5  1996/02/22 00:08:35  elf
 * Added FORCE_STRIP_CR to rcsedit.  Added code to strip spaces from end of RCSLINK.  Removed vestigal code that worked around bug in DJGPP's exec code.
 *
 * Revision 1.4  1995/09/15 18:19:50  elf
 * Simplified compose_bin_path changes.  Fixed spawn from clobbering program name
 *
 * Revision 1.3  1995/09/14 03:10:11  elf
 * Patches for DOS bugs found with CVS.
 *
 * Revision 1.2  1995/08/22 00:06:13  elf
 * Changes for CVS
 *
 * Revision 1.1  1995/08/03 05:16:29  elf
 * MS-DOS patches 7.2
 *
 */


#include "rcsbase.h"
#include "glob.h"

#if defined (RCS_SOFTLINKS)

/* clean_path_separators

   converts all backslash characters to forward slashes.  This is to
   prevent the internals from being confused by the escape.  Note
   that this should only be done on MS-DOS machines as is the case
   for all of this soft-links stuff.

*/

void clean_path_separators (char* sz)
{
  for ( ;*sz; ++sz)
    if (*sz == '\\')
      *sz = '/';
}  /* clean_path_separators */


/* compose_bin_path

   allows the user to control the path from where RCS programs are
   executed.  This is for speed because DOS searches the path so
   slowly.

*/

char* compose_bin_path (char* szProgram)
{
#if !defined (BINPATHVAR)
  return szProgram;
#else
  char* szPathBinary;
  char* pch;
  char* szPath = NULL;

	/* Check for absolute path */
  if (   isSLASH (*szProgram)
      || (isalpha (*szProgram) && szProgram[1] == ':'))
    return szProgram;

	/* Fetch binary's path */
  szPathBinary = getenv (BINPATHVAR);
  if (!szPathBinary || !*szPathBinary)
    return szProgram;
  
	/* Normalize/compose binary's path */
  szPath = malloc (strlen (szPathBinary) + strlen (szProgram) + 2);
  if (!szPath)
    return szProgram;
  strcpy (szPath, szPathBinary);
  clean_path_separators (szPath);
  if (szPath[strlen (szPath) - 1] != '/')
    strcat (szPath, "/");
  strcat (szPath, szProgram);
  return szPath;
#endif
}  /* compose_bin_path */


/* find_path_length

   returns the length of the path portion of the filename.  If there
   are no path separators, then zero is returned.  If there are
   separators, the return count is the offset to the last separator.

*/

int find_path_length (char* sz)
{
  int cch = 0;
  int ich;
  while ((ich = strcspn (sz + cch, "/\\")), sz [cch + ich])
    cch += ich + 1;
  if (cch)
    --cch;
  return cch;
}  /* find_path_length */


/* resolve_link

   opens a the pathname for a file to see if it is a soft link
   emulation file.  The returned pointer is the contents of the link
   file.

*/

char* resolve_link (char* sz, int cch)
{
  FILE* fp;
  static char* szLink;
  char* szPath = NULL;

  if (szLink) {				/* Release previous link data */
    free (szLink);
    szLink = NULL;
  }  /* if */

  szPath = (char*) malloc (cch + 1);	/* Allocate space for pathname */
  strncpy (szPath, sz, cch);
  szPath[cch] = 0;
  
  fp = fopen (szPath, "rb");
  if (fp) {
    int cchLink;			/* Calc length of data and read */
    fseek (fp, 0, SEEK_END);
    cchLink = ftell (fp);
    if (cchLink < PATH_MAX) {
      fseek (fp, 0, SEEK_SET);
      szLink = (char*) malloc (cchLink + 1);
      cchLink = fread (szLink, 1, cchLink, fp);
      szLink[cchLink] = 0;
    }  /* if */
    else
      cchLink = 0;
    fclose (fp);

    if (!cchLink && szLink) {		/* Cleanup if empty */
      free (szLink);
      szLink = NULL;
    }  /* if */

    if (szLink) {
      cchLink = strcspn (szLink, "\n\r"); /* Ignore multiple lines */
      szLink[cchLink] = 0;
    }  /* if */
  }  /* if */

  free (szPath);

  if (szLink) {
	/* Remove trailing spaces, cause this seems to happen sometimes */
    int i;
    for (i = strlen (szLink); --i >= 0;) {
      if (szLink[i] != ' ')
	break;
      szLink[i] = 0;
    }  /* for */
    clean_path_separators (szLink);
  }  /* if */

  return szLink;
}  /* resolve_link */


/* expand_argv_links

   expands the argv list for wildcards via soft links.  Since our
   links are expanded after the standard wildcard expansion, we
   perform another expansion here.  Presently, we only expand a
   single asterisk wildcard.

*/

void expand_argv_links (int* pargc, char*** pargv)
{
  int cArgOriginal = *pargc;
  char** argvOriginal = *pargv;
  int cchPathname;
  glob_t a_glob;
  char* szFilename = NULL;
  int cchMax = 0;

  memset (&a_glob, 0, sizeof (a_glob));

  for (; cArgOriginal--; ++argvOriginal) {
    int ichWild = strcspn (*argvOriginal, "*[]?"); /* All wildcards */
    char* szLink;
    clean_path_separators (*argvOriginal);
    if (*argvOriginal[0] != '-' && (*argvOriginal)[ichWild]
	&& (cchPathname = find_path_length (*argvOriginal))
	&& (szLink = resolve_link (*argvOriginal, cchPathname))) {
      if (cchMax < strlen (szLink) + strlen (*argvOriginal) - cchPathname) {
	if (szFilename)
	  free (szFilename);
	szFilename = malloc (cchMax = strlen (szLink)
			     + strlen (*argvOriginal) - cchPathname);
      }  /* if */
      strcpy (szFilename, szLink);
      strcat (szFilename, *argvOriginal + cchPathname);
      glob (szFilename, GLOB_APPEND | GLOB_NOSORT | GLOB_NODOTDIR,
	    NULL, &a_glob);
    }  /* if */
    else
      glob (*argvOriginal, GLOB_APPEND | GLOB_NOSORT | GLOB_NOCHECK,
	    NULL, &a_glob);
  }  /* while */

  *pargc = a_glob.gl_pathc;
  *pargv = a_glob.gl_pathv;
}  /* expand_argv_links */


void follow_rcs_link (struct buf* Buffer)
{
  struct buf BufferNew;
  int cch;
  char* szFilename;
  char* szLink;
  
  cch = find_path_length (Buffer->string);
  if (!cch)
    cch = strlen (Buffer->string);
  szFilename = &Buffer->string[cch];

  szLink = resolve_link (Buffer->string, cch);
  if (!szLink)
    return;

  memset (&BufferNew, 0, sizeof (struct buf));
  bufalloc (&BufferNew, strlen (szLink) + strlen (szFilename) + 1);
  strcpy (BufferNew.string, szLink);
  strcat (BufferNew.string, szFilename);
      
  bufautoend (Buffer);
  Buffer->string = BufferNew.string;
  Buffer->size = BufferNew.size;
}  /* follow_rcs_link */

#endif
