#  Sed script to adapt init.sh and init.cfg in ./testsuite.

# Set the path separator to a default.
# Do not trust any autotools specific code to find DOS/DJGPP required path separator.
/^if test.*PATH_SEPARATOR+set.*then$/ i\
export PATH_SEPARATOR=${PATH_SEPARATOR=:}

# DJGPP specific changes for remove_tmp_
/^remove_tmp_[ 	]*()/,/^}$/ {
  # Support TMPDIR, TMP and TEMP in remove_tmp_ too.
  /cd.*initial_cwd_/ s/||/& cd "${TMPDIR=${TMP=${TEMP=.}}}" &/

  # When the temporary directory cannot be removed,
  # do not let the check fail.
  /rm -rf .* || { test .* __st=1; }$/ {
    s/test /test "x\${DJDIR}" = "x" \&\& test /
  }
}

# DJGPP specific changes for mktempd_
/^mktempd_[ 	]*()/,/^}$/ {
  # mktempd_ is not able to handle paths with DOS specific drive specifiers.
  /^[ 	]*\/[ 	]*|[ 	]*\/*\/)/ s,\/),/ | ?:[\\/]),
  /^[ 	]*\*\/)/ s,\*\/),*[\\/]),

  # Do not clobber the TMPDIR.
  /d=/ s/unset TMPDIR;/& unset TMP; unset TEMP;/

  # Do not try to handle sticky bits.  This makes no sense for DOS.
  # Especially the encoding of the permission bits of DOS do not match the POSIX ones.
  /drwx-/ s/;;/;; ----d-*) :;;/
}
