/*****************************************************************************

  This code is copyrighted by Salvador Eduardo Tropea. (c) 1996.

  You can use, distribute and modify this code with the following
restrictions:

1) You can't remove this text.
2) You must say who is the original author.
3) You can't receive money for this files, this includes the binarys
generated with this sources, without my consent. (only a minimal amount for
the media is allowed without my consent (floppy disk <= 5 U$S, CD <= U$S 35)).
4) You can't modify the copyrights inside ginf.spa and ginf.eng, and
if you generate a convertion from any GNU's inf this convertion must include
ginf.spa or ginf.eng.

  The following aren't restictions but requests:

1) If you find any bug please inform it to me.
2) If you make enhacements or derivated work share it with me.
3) If you use this code or the files generated e-mail, or send a letter,
to me.

  Some of the projects i have in mind are the followings:

1) A FAQ's to NG coverter (seems to be easy)
2) A TEX to NG converter (not so easy)
3) A generic INF to NG converter (i'm developing it)

  If you plan to do some of these, e-mail to me.

  Share and enjoy, but not abuse.

E-Mail: ice@inti.edu.ar

Telephone: (+541) 759-0013

Postal Address:
Salvador E. Tropea
Curapalige 2124
(1678) Caseros - 3 de Febrero
Prov: Buenos Aires
Argentina

*****************************************************************************/
/*****************************************************************************

  Hi, man: Some things about the program:
  
1) If you take a look at this you will see that the routines that parses the
   .INF are a little stupid, this is becouse i don't know what's the whole
   specification for the .INF files.
   
2) This program works with the following files:
   
   GCC.INF      from GCC 2.7.2
   CPP.INF	from GCC 2.7.2
   AS.INF       from BNU 2.5.2
   GASP.INF     from BNU 2.5.2
   BINUTILS.INF from BNU 2.5.2
   LIBC.INF     from DJDEV 2.0.0 (but is better is you use INFA to convert it)
   UTILS.INF    from DJDEV 2.0.0
   DIFF.INF     from DIF 2.7.1
   GDB.INF	from GDB 4.1.2
   LIBGPLUS.INF from LGP 2.7.1
   IOSTREAM.INF from LGP 2.7.1
   MAKE.INF	from MAK 3.7.3
   DJGPPFAQ.INF from FAQ 2.0.0 b 

*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "setstd.h"
#include "compila.hpp"

// ***************** DJGPP v2.0 v.s. BC++ 3.1
#ifdef __GNUC__

#include <unistd.h>
#include <go32.h>
#include <dpmi.h>

ULONG farcoreleft(NADA)
{
 _go32_dpmi_meminfo info;
 _go32_dpmi_get_free_memory_information(&info);
 if (info.available_physical_pages != -1)
   return info.available_physical_pages * 4096;
 return info.available_memory;
}

#else // !__GNUC__

#define inline
#include <alloc.h>

#endif


// ************* Buffers for lines readed
char Buff[256+1];
char Buff2[256+1];

// ************* Try to open with rt and go crazy
#define FOPEN_READ  "rb"
#define FOPEN_WRITE "wb"

// ************* Debug flags
//#define DEBUG
//#define PESADO

#ifdef PESADO
// ***** paranoic but good checks:

void *operator new(size_t size)
{
 void * p;

 size = size ? size : 1;
 p = malloc(size);
 if (p==NULL)
   {
    printf("Error Memoria AGOTADA!!!\n");
    exit(1);
   }

 return p;
}

void operator delete(void *p)
{
 if (p==NULL)
   {
    printf("Error Liberando un NULL!!!\n");
    exit(1);
   }
 free(p);
}

inline
void PesadoSi(int cond, char* Lugar)
{
 if (cond)
   {
    printf("Upss!! %s\n",Lugar);
    exit(1);
   }
}

void TomarLinea(FILE *f)
{
 if (f==NULL)
   {
    printf("Aaaaahhhh!!!!\n");
    exit(1);
   }
 long Pos1=ftell(f);
 if (fgets(Buff,256,f)==NULL)
   {
    printf("------> EOF\n");
   }
 if (strlen(Buff)>220)
   {
    printf("Cuidadito ....\n");
    exit(1);
   }
}

#else

#define PesadoSi(a,b);
#define TomarLinea(a) fgets(Buff,256,a)

#endif

#define PonerLinea(a) fputs(Buff,a)


// ***************** Language strings, correct my english please ...
//#define ESPANOL

#ifdef ESPANOL

#define S_Intro  "Introduccin"
#define S_IntroT "Textos Introductorios"
#define S_Funcs  "Funciones"
#define S_FuncsN "Funciones por Nombre"
#define S_ECrea1 "Error al crear %s\n"
#define S_EAbre1 "Error al abrir %s\n"
#define S_Mide   "Midiendo el archivo ... "
#define S_CopyF  "Copiando funcin"
#define S_ENoNod "No pude encontrar el nodo"
#define S_Reco   "Recolectando los nodos y notes ... "
#define S_NLN    "Nodos: %d Lneas: %d Notas"
#define S_NoRAM  "No hay RAM suficiente\n"
#define S_MiCopy "Convertido a NG por SET (Salvador Eduardo Tropea)\n"
#define S_IDIO   "SPA"
#define S_Tiempo "Tiempo de conversin,compilado y linkeado: %f segundos\n"
#define S_LOverf "Lnea overflow\n"
#define S_Bucand "Buscando: %s - "
#define S_Encont "Encontrado, copindolo ...\n"
#define S_NoEnco "No encontrado, fin\n"
#define S_FinIne "Fin inesperado nodo\n"
#define S_TomaLi "Tomando el link: %s (%ld->%ld)\n"
#define S_Conten "Contenido"
#define S_AgreNo "Agregando el nodo: %s (%ld)\n"
#define S_Contin "Contina ..."
#define S_IndMuy "Indice muy largo, cortado en %d entradas\n"
#define S_NoEnCo "No encontrado: %s\n"
#define S_NoDisp "No disponible"
#define S_AtNomb "---> Atencin, no posee nombre\n"
#define S_Texto  "Texto"
#define S_Menues "Menes"
#define S_Indice "Indice"
#define S_LargoTot   "Largo total: %ld\n"
#define S_ResoRe "Resolviendo referencias\n"
#define S_ConcaA "Concatenando el archivo\n"
#define S_NomPrg     "Conversor de .inf a NG. (c) 1996 por SET (Salvador E. Tropea)\n\n"
#define S_Uso    "Uso: %s Base.inf Temporal NG.ng\n"

#else

#define S_Intro  "Introduction"
#define S_IntroT "Introduction Texts"
#define S_Funcs  "Functions"
#define S_FuncsN "Functions by Name"
#define S_ECrea1 "Can't create: %s\n"
#define S_EAbre1 "Can't open: %s\n"
#define S_Mide   "First pass to the archive ... "
#define S_ENoNod "Can't find the node"
#define S_Reco   "Collecting nodes and notes ... "
#define S_NLN    "Nodes: %d Lines: %d Notes"
#define S_NoRAM  "Not enough memory\n"
#define S_MiCopy "Converted to NG by SET (Salvador Eduardo Tropea)\n"
#define S_IDIO   "ENG"
#define S_Tiempo "Convertion/Compile/Link time: %f segs\n"
#define S_LOverf "Line overflow\n"
#define S_Bucand "Searching: %s - "
#define S_Encont "found, copying ...\n"
#define S_NoEnco "Not found, end\n"
#define S_FinIne "Unexpected end of node\n"
#define S_TomaLi "Taking the link: %s (%ld->%ld)\n"
#define S_Conten "Contents"
#define S_AgreNo "Adding the node: %s (%ld)\n"
#define S_Contin "Continue ..."
#define S_IndMuy "Very large index, cutting at %d entrys\n"
#define S_NoEnCo "%s not found\n"
#define S_NoDisp "Nothing"
#define S_AtNomb "---> Attention, file without name\n"
#define S_Texto  "Text"
#define S_Menues "Menu"
#define S_Indice "Index"
#define S_LargoTot   "Total size: %ld\n"
#define S_ResoRe "Solving references\n"
#define S_ConcaA "Joining the files\n"
#define S_NomPrg ".inf to NG converter. (c) 1996 by SET (Salvador E. Tropea)\n\n"
#define S_Uso    "Use: %s Base.inf Temp NG.ng\n"

#endif

// ***************** 80 is enough for the files that I see.
#define NOM_MAX 80

char sContinua[NOM_MAX];
char sNombreArchivo[NOM_MAX];
char sNombreGuia[NOM_MAX];
char sNombreNodo[NOM_MAX];
char *sSeparador={""};
int LineasAExcluirCopy=0;


// *********************** This method is wrong, but is better to nothing
void TomarLineaTabExpand(FILE *f)
{
 TomarLinea(f);

 int Largo;
 Largo=strlen(Buff)-2;
 // Es una lnea de DOS?
 if (Buff[Largo+1]=='\n' && Buff[Largo]=='\r')
   { // Si => Llevarla a simple
    Buff[Largo]='\n';
    Buff[Largo+1]=0;
    Largo--;
   }
   
 char *pos=Buff;
 char *aux,*auxdest,*fin;
 fin=&Buff[Largo+2];
 for (; *pos; pos++)
    {
     if (*pos==9) // Tab
       {
        // Mover 7 ms all
        if (Largo>245)
          {
           printf(S_LOverf);
           exit(1);
          }
        for (auxdest=fin+6,aux=fin; aux!=pos; aux--,auxdest--) *auxdest=*aux;
        for (; auxdest!=pos; auxdest--) *auxdest=' ';
        *pos=' ';
        pos+=6;
        fin+=7;
        Largo+=7;
       } 
    }
}

/*****************************************************************************

 Archivo en memoria para acumular un texto

*****************************************************************************/

char BufMFile[16348+256*2];
char *ucpPosMFile=BufMFile;
WORD uiLineasMFile;

inline
void RebobinaMFile()
{
 ucpPosMFile=BufMFile;
 uiLineasMFile=0;
}

int PoneEnMFile(char *s)
{
 for (;*s;ucpPosMFile++,s++)
     *ucpPosMFile=*s;
 *ucpPosMFile=0;
 ucpPosMFile++;
 uiLineasMFile++;
 if ((ucpPosMFile-BufMFile)>16348)
   {
    printf("Exceso en MFile\n");
    return 1;
   }
 return 0;
}

/****************** Fin MFile *****************/

void ErrorMem(void)
{
 printf(S_NoRAM);
 exit(1);
}

FILE *AbrirArchivo(char *nom,char *modo)
{
 FILE *f;
 if ((f=fopen(nom,modo))==NULL)
   {
    printf(S_EAbre1,nom);
    exit(1);
   }
 return f;
}

void CopiarNodo(FILE *d,FILE *f)
{
 do
  {
   TomarLineaTabExpand(f);
   PonerLinea(d);
  }
 while (Buff[0]!=31 && !feof(f));
}


int SaltearNodo(FILE *f)
{
 int Salteadas=0;

 do
  {
   TomarLinea(f);
   Salteadas++;
  }
 while (Buff[0]!=31 && !feof(f));

 return Salteadas;
}


int SaltearNodoBuscaMenu(FILE *f,int &TieneMenu)
{
 int Salteadas=0;

 TieneMenu=0;
 do
  {
   TomarLinea(f);
   if (Buff[0]=='*')
     {
      if (strncmp(Buff,"* Menu",6)==0)
         TieneMenu=1;
     }
   Salteadas++;
  }
 while (Buff[0]!=31 && !feof(f));

 return Salteadas;
}

void Concatenar(char *nom,char *dest)
{
 int i,SinI=0;
 char BufNom[128];
 char BufExt[5];

 strcpy(BufNom,nom);
 strcat(BufNom,".inf");

 FILE *hDest=AbrirArchivo(dest,FOPEN_WRITE);
 FILE *h=AbrirArchivo(BufNom,FOPEN_READ);
 CopiarNodo(hDest,h);

 i=1;
 strcpy(BufExt,".i1");
 strcpy(BufNom,nom);
 strcat(BufNom,BufExt);
 printf(S_Bucand,BufNom);
 if (access(BufNom,0)!=0)
   {
    SinI=1;
    strcpy(BufExt,".1");
    strcpy(BufNom,nom);
    strcat(BufNom,BufExt);
   }
 if (access(BufNom,0)==0)
   {
    fclose(h);
    while (access(BufNom,0)==0)
       {
        printf(S_Encont);
        h=AbrirArchivo(BufNom,FOPEN_READ);
        SaltearNodo(h);
        while (!feof(h))
              CopiarNodo(hDest,h);
        fclose(h);

        i++;
        if (SinI)
           sprintf(BufExt,".%-d",i);
        else
           sprintf(BufExt,".i%-d",i);
        strcpy(BufNom,nom);
        strcat(BufNom,BufExt);
        printf(S_Bucand,BufNom);

        if (access(BufNom,0)==0)
          {
           strcpy(Buff,"\x1f\n");
           PonerLinea(hDest);
          }
       }
   }
 else
   {
    while (!feof(h))
          CopiarNodo(hDest,h);
    fclose(h);
   }
 printf(S_NoEnco);

 fclose(hDest);
}


char *TomaHastaComa(char *Destino, char *Fuente)
{
 for (;*Fuente!=':' && *Fuente; Fuente++);
 PesadoSi(!*Fuente,"TomaHastaComa");
 for (Fuente+=2; *Fuente!=',' && *Fuente; Fuente++,Destino++)
     *Destino=*Fuente;
 *Destino=0;

 return Fuente;
}


int TomarNombreNodo(char *Nom,FILE *h)
{
 char *Pos;

 TomarLinea(h);
 if (strncmp(Buff,"File",4)==0)
   {
    // File:
    Pos=TomaHastaComa(Nom,Buff);
    PesadoSi(strlen(Nom)>NOM_MAX,"TomarNombreNodo 1");
    // Node:
    Pos=TomaHastaComa(Nom,Pos);
    PesadoSi(strlen(Nom)>NOM_MAX,"TomarNombreNodo 2");
    return 1;
   }

 return 0;
}


int CantNodos;
typedef struct
{
 char Nombre[NOM_MAX];
 long Pos;
 int  TieneMenu;
 int  FueAgregado;
} iNodo;
iNodo *Nodos;

void CrearIndice(FILE *hOri)
{
 int CantLineas=0;
 char *s1,*s2,*s,*sb;
 char Molinete[]={ '','/','-','\\' };

 printf(S_Mide);
 do
  {
   CantLineas+=SaltearNodo(hOri);
   CantNodos++;
   printf("\x8%c",Molinete[CantNodos & 3]);
   fflush(stdout); // This is crazy but needed for DJGPP
  }
 while(!feof(hOri));
 printf("\x8 \n" S_NLN ": %d => %u+%u bytes\n",
        CantNodos,CantLineas,0,CantNodos*sizeof(iNodo),0);
 fseek(hOri,0,SEEK_SET);

 if ((Nodos=(iNodo *)malloc(CantNodos*sizeof(iNodo)))==NULL) ErrorMem();

 memset((void *)Nodos,0,CantNodos*sizeof(iNodo));

 CantNodos=0;
 //CantNotas=0;
 SaltearNodo(hOri);
 printf(S_Reco);
 do
  {
   Nodos[CantNodos].Pos=ftell(hOri);
   if (TomarNombreNodo(Nodos[CantNodos].Nombre,hOri))
     {
      #ifdef DEBUG
      printf("Nodo: %s\n",Nodos[CantNodos].Nombre);
      #endif
      SaltearNodoBuscaMenu(hOri,Nodos[CantNodos].TieneMenu);
      Nodos[CantNodos].FueAgregado=0;
      CantNodos++;
      printf("\x8%c",Molinete[CantNodos & 3]);
      fflush(stdout);
     }
   else
      SaltearNodo(hOri);
  }
 while(!feof(hOri));
 printf("\x8 \n");

 fseek(hOri,0,SEEK_SET);
}

void CopiarCredito(NGArchivo& o,FILE *f)
{
 int Cont=LineasAExcluirCopy-2;

 if (Cont>0)
    while (Cont--) TomarLinea(f);

 TomarLinea(f);
 o.AgregarCopy(Buff);
 o.AgregarCopy(S_MiCopy); // Hey!!! Do you contact me?
 o.AgregarCopy("Buenos Aires, Argentina. e-mail ice@inti.edu.ar\n");
 SaltearNodo(f);
}

void SaltearEspacios(FILE *hc)
{
 do
  {
   TomarLinea(hc);
  }
 while ((Buff[0]==' ' || Buff[0]=='\n' || Buff[0]=='\x9' || Buff[0]=='\r') && !feof(hc));
}

FILE *hc;

int BuscaNodo(char *Nombre)
{
 int i;

 for (i=0; i<CantNodos && strcmp(Nodos[i].Nombre,Nombre)!=0; i++);
 if (i==CantNodos)
   {
    printf("Error: " S_ENoNod ": %s\n",Nombre);
    exit(1);
   }

 fseek(hc,Nodos[i].Pos,SEEK_SET);
 Nodos[i].FueAgregado=1;

 return Nodos[i].TieneMenu;
}

void SepararNombreNodo(char *dest,char *ori)
{
 char *dest1=dest;
 for (;*ori=='*' || *ori==' ';ori++);
 for (*dest++=*ori++;*ori && *ori!=':'; ori++,dest++) *dest=*ori;
 if (*ori==':' && *(ori+1)!=':') // Lo que sigue es el nombre
   {
    dest=dest1;
    ori++;
    for (;*ori=='*' || *ori==' ';ori++);
    for (;*ori && *ori!=':' && *ori!='.'; ori++,dest++) *dest=*ori;
   }
 PesadoSi((dest-dest1)>250,"SepararNombreNodo");
 *dest=0;
}

void SepararNombreYNodo(char *nom,char *nodo,char *ori)
{
 for (;*ori=='*' || *ori==' ';ori++);
 for (*nom++=*ori++;*ori && *ori!=':'; ori++,nom++) *nom=*ori;
 *nom=0;
 if (*++ori==':') 
   {
    ori++;
    if (!isspace(*ori))
      { 
       *nom++=':';
       *nom++=':';
       for (*nom++=*ori++;*ori && *ori!=':'; ori++,nom++) *nom=*ori;
       *nom=0;
      }
   }
 if (*++ori==':') ori++;
 for (;*ori=='\x9' || *ori==' ';ori++);
 char *nodoori=nodo;
 for (*nodo++=*ori++;*ori && *ori!='\n' && *ori!='.' && *ori!=':'; ori++,nodo++) *nodo=*ori;
 if (*ori==':')
   {
    for (ori++;*ori && isspace(*ori); ori++);
    for (nodo=nodoori,*nodo++=*ori++;*ori && *ori!='\n' && *ori!='.' && *ori!=':'; ori++,nodo++) *nodo=*ori;
   }
 *nodo=0;
}

void SepararNombreNodoLindo(char *dest,char *ori)
{
 for (;*ori=='*' || *ori==' ';ori++);
 for (*dest++=*ori++;*ori && *ori!='\n'; ori++)
    {
     if (*ori!=':')
        *dest++=*ori;
    }
 //PesadoSi((dest-dest1)>250,"SepararNombreNodoLindo");
 *dest=0;
}

int NoEsIndice(char *Buff);

void PonerTexto(NGShort *o,char *Buf,int Lineas)
{
 char *Pos,*s1,*s2,*Texto,*PosCorta;
 char SeeAlso[NOM_MAX*2];
 int Saltear,LineaCortada;

 Texto=Buf;
 // Escanear buscado *notes
 for (int i=0; i<Lineas; i++)
    {
     Saltear=0;
     do
      {
       s1=strstr(Buf,"*note ");
       if (s1==NULL)
          s1=strstr(Buf,"*Note ");
       if (s1!=NULL)
         {
          Pos=s1;
          // Tomar el nombre
          s1+=6;
          for (;*s1 && isspace(*s1); s1++); // Saltear espacios
          s2=SeeAlso;
          for (;*s1 && *s1!=':' && *s1!='\n'; s1++,s2++) *s2=*s1; // Copiar el nombre
          if (*s1=='\n') 
            {
             *s2++=*s1++;
             for (;*s1; s1++); // Saltear espacios
            }
          *s2=0;
          if (*s1) // Llegu al :
            {
             LineaCortada=0;
             s1++;
             for (;*s1 && isspace(*s1); s1++); // Saltear espacios
             if (*s1!=':')
               { // Da un alias
                if (*s1!='(')
                  {
                   s2=SeeAlso;
                   for (;*s1 && *s1!=':' && *s1!='.' && *s1!=','; s1++,s2++) *s2=*s1;
                   *s2=0;
                   if (!*s1 || *s1==':') // Basta loco sigue aliaseando?
                      Saltear=1;
                  }
                else
                   Saltear=1; // hace referencia a otro archivo
               }
            }
          else
            {
             LineaCortada=1;
             // Se fue a la prxima lnea
             if (i<(Lineas-1))
               {
                PosCorta=s1;
                s2--;
                *s2=32;
                s2++;
                s1++;
                for (;*s1 && isspace(*s1); s1++);
                for (;*s1 && *s1!=':'; s1++,s2++) *s2=*s1;
                *s2=0;
                if (*s1)
                  {
                   s1++;
                   for (;*s1 && isspace(*s1); s1++);
                   if (*s1!=':')
                     { // Da un alias
                      if (*s1!='(')
                        {
                         s2=SeeAlso;
                         for (;*s1 && *s1!=':' && *s1!='.' && *s1!=','; s1++,s2++) *s2=*s1;
                         *s2=0;
                         if (!*s1 || *s1==':')
                            Saltear=1;
                        }
                      else
                         Saltear=1; // hace referencia a otro archivo
                     }
                  }
                else
                  Saltear=1;
               }
             else
                Saltear=1;
            }
          PesadoSi(strlen(SeeAlso)>NOM_MAX,"PonerTexto");
          if (!Saltear && strlen(SeeAlso)!=0)
            {
             PesadoSi(o==NULL,"PonerTexto 2");
             if (NoEsIndice(SeeAlso))
                o->AgregarSeeAlso(SeeAlso);
             // Compactarlo
             if (LineaCortada)
               {
                *Pos='^';
                *(Pos+1)='B';
                s1-=3;
                PosCorta-=4;
                for (Pos+=2; Pos!=PosCorta; Pos++) *Pos=Pos[4];
                *Pos='^';
                *(Pos+1)='B';
                *(Pos+2)=0;
                *(Pos+3)='^';
                *(Pos+4)='B';
                Pos=s1+3;
                Pos[0]='^';
                Pos[1]='B';
               }
             else
               {
                *Pos='^';
                *(Pos+1)='B';
                s1-=3;
                for (Pos+=2; Pos!=s1; Pos++) *Pos=Pos[4];
                Pos--;
                Pos[0]='^';
                Pos[1]='B';
                Pos[2]=' ';
                Pos[3]=' ';
                Pos[4]=' ';
                // Ahora mover los espacios
                s1=Pos+2;
                for (Pos+=4;*Pos && isspace(*Pos);Pos++); // Buscar donde terminan
                if (*Pos!=')' && *Pos!='.' && *Pos!=',') s1++;
                for (;*Pos;Pos++,s1++) *s1=*Pos; // Mover el texto hacia atras
                for (;s1!=Pos;s1++) *s1=' '; // Rellenar con espacios
               }
            }
         }
      }
     while (!Saltear && s1!=NULL);
     // Proxima lnea
     for (;*Buf;Buf++);
     Buf++;
    }
 o->PonerTexto(Texto,Lineas);
}

NGShort *UnTitulo;
 // Crear la copa del rbol
NGListaPura Lp;
NGVariosShort *OtroNodo;
int NivelItera=-1;

void AgregaTexto1(NGVariosShort *ElNodo)
{
 int Continuaciones=0;
 int iPos=strlen(sContinua);

 PesadoSi(iPos+5>NOM_MAX,"AgregaTexto1");
 do
  {
   //lUltPos=ftell(hc);
   TomarLinea(hc);
   
   if (Buff[0]==31 || strncmp(Buff,"* Menu",6)==0)
      break;
   else
     {
      if (PoneEnMFile(Buff))
        {
         // Si desbord:
         if (Continuaciones)
           {
            sContinua[iPos]=32;
            sContinua[iPos+1]=48+Continuaciones;
            sContinua[iPos+2]=0;
           }
         PonerTexto(UnTitulo,BufMFile,uiLineasMFile);
         UnTitulo->AgregarSeeAlso(sContinua);
         RebobinaMFile();
         UnTitulo = new NGShort(sContinua);
         ElNodo->Agregar(*UnTitulo,Lp);
         Continuaciones++;
        }
     }
  }
 while(!feof(hc));
 
 PonerTexto(UnTitulo,BufMFile,uiLineasMFile);
}

int NoEsIndice(char *Buff)
{
 return strncmp(Buff,"Index",5)!=0 && strncmp(Buff,"Concept Index",13)!=0
        && strncmp(Buff,"Name Index",10)!=0
        && strncmp(Buff,"Topic Index",13)!=0;
}

void VerSiFinPrematuro(void)
{
 if (Buff[0]==31)
   {
    printf(S_FinIne);
    exit(1);
   }
}

int AtacharEste=0;

void ConvertirTodo(NGVariosShort& o,int TieneMenu)
{
 long lUltPos;
 NGVariosShort *ElNodo;

 NivelItera++;
 // Saltear: File ...
 TomarNombreNodo(Buff2,hc);
 if (strncmp(Buff2,"Index",5)==0)
   {
    NivelItera--;
    return;
   }

 if (TieneMenu)
   {
    PesadoSi(strlen(Buff2)>NOM_MAX,"ConvertirTodo 1");
    strcpy(sNombreNodo,Buff2);
    if (AtacharEste)
      {
       ElNodo = new NGVariosShort(Buff2);
       o.Agregar(*ElNodo,Lp);
      }
    else
      {
       ElNodo = &o;
       AtacharEste=1;
      }

    SaltearEspacios(hc);

    VerSiFinPrematuro();

    //YaPusoNombreNodo=0;
    while (strncmp(Buff,"* Menu",6)!=0)
     {
      // Si no es un link
      // Me top con el ttulo, crear un tipo 1 para l
      RebobinaMFile();

      Buff[strlen(Buff)-1]=0;
      sprintf(sContinua,"%s (Cont.)",Buff);
      PesadoSi(strlen(sContinua)>NOM_MAX,"ConvertirTodo 2");
      sprintf(Buff2,"^B%s^B",Buff);
      UnTitulo = new NGShort(Buff2,sNombreNodo);
      PoneEnMFile(Buff2);

      ElNodo->Agregar(*UnTitulo,Lp);

      // Ahora leer hasta: 1) que termine el nodo o 2) que termine el file
      // o 3) Que aparezca un men
      AgregaTexto1(ElNodo);
      if (feof(hc) || Buff[0]==31)
        {
         NivelItera--;
         return;
        }
     }
    UnTitulo = new NGShort(sSeparador);
    ElNodo->Agregar(*UnTitulo,Lp);
    // Ahora me top con el men
    SaltearEspacios(hc);
    VerSiFinPrematuro();
    do
     {
      lUltPos=ftell(hc);
      SepararNombreNodo(Buff2,Buff);
      if (NoEsIndice(Buff2)  && strncmp(Buff2,"Note ",5)!=0 && Buff2[0]!='(')
        {
         int TieneMenu=BuscaNodo(Buff2);
         for (int i=0;i<NivelItera;i++) printf(" ");
         printf(S_TomaLi,Buff2,lUltPos,ftell(hc));
         SepararNombreNodoLindo(sNombreNodo,Buff);
         ConvertirTodo(*ElNodo,TieneMenu);
         fseek(hc,lUltPos,SEEK_SET);
        }
      SaltearEspacios(hc);
     }
    while(Buff[0]=='*');
    
    if (Buff[0]!=31 && !feof(hc))
      {
       RebobinaMFile();

       UnTitulo = new NGShort(sSeparador);
       ElNodo->Agregar(*UnTitulo,Lp);
       UnTitulo = new NGShort(S_Conten);
       ElNodo->Agregar(*UnTitulo,Lp);
       strcpy(sContinua,S_Conten " (Cont.)");

       // Ahora leer hasta: 1) que termine el nodo o 2) que termine el file
       // o 3) Que aparezca un men
       AgregaTexto1(ElNodo);

       if (feof(hc) || Buff[0]==31)
         {
          NivelItera--;
          return;
         }
      }
   }
 else
   {
    UnTitulo= new NGShort(sNombreNodo,Buff2);
    o.Agregar(*UnTitulo,Lp);
    sprintf(sContinua,"%s (Cont.)",Buff2);
    PesadoSi(strlen(sContinua)>NOM_MAX,"ConvertirTodo 3");

    SaltearEspacios(hc);

    VerSiFinPrematuro();

    RebobinaMFile();

    Buff[strlen(Buff)-1]=0;
    sprintf(Buff2,"^B%s^B\n",Buff);
    PoneEnMFile(Buff2);

    // Ahora leer hasta: 1) que termine el nodo o 2) que termine el file
    // o 3) Que aparezca un men
    AgregaTexto1(&o);
   }
 NivelItera--;
}

int BuscarSiDiceNombre(FILE *hOri)
{
 LineasAExcluirCopy=0;
 do
  {
   TomarLinea(hOri);
   LineasAExcluirCopy++;
   if (strncmp(Buff,"START-INFO-DIR-ENTRY",20)==0)
     {
      // La siguiente lnea es la informacin sobre el nombre
      TomarLinea(hOri);
      char *s=Buff;
      char *s2=sNombreArchivo;
      for (;*s && *s!=':'; s++,s2++) *s2=*s;
      *s2=0;
      for (s++;*s && isspace(*s); s++);
      if (*s=='(')
        {
         s2=sNombreArchivo;
         for (s++;*s && *s!=')'; s++,s2++) *s2=*s;
         *s2=0;
        }
      for (s+=2;*s && isspace(*s); s++);
      s2=sNombreGuia;
      for (;*s && *s!='\n' && *s!='\r'; s++,s2++) *s2=*s;
      *s2=0;
      LineasAExcluirCopy+=2;
      return 1;
     }
  }
 while(Buff[0]!=31);
 return 0;
}

void AgregarSueltos(NGVariosShort &o,NGVariosShort *Indice)
{
 int i,PrimerAgrega=1,LargoAcum=0,Entradas=0;
 NGShort *Uno;

 for (i=0; i<CantNodos; i++)
    {
     if (!Nodos[i].FueAgregado)
       {
        fseek(hc,Nodos[i].Pos,SEEK_SET);
        if (NoEsIndice(Nodos[i].Nombre))
          {
           if (PrimerAgrega)
             {
              UnTitulo = new NGShort(sSeparador);
              o.Agregar(*UnTitulo,Lp);
              PrimerAgrega=0;
             }
           printf(S_AgreNo,Nodos[i].Nombre,Nodos[i].Pos);
           UnTitulo = new NGShort(Nodos[i].Nombre);

           o.Agregar(*UnTitulo,Lp);
           sprintf(sContinua,"%s (Cont.)",Nodos[i].Nombre);
           PesadoSi(strlen(sContinua)>NOM_MAX,"AgregarSueltos");

           TomarLinea(hc);
           SaltearEspacios(hc);

           VerSiFinPrematuro();
           RebobinaMFile();

           Buff[strlen(Buff)-1]=0;
           sprintf(Buff2,"^B%s^B\n",Buff);
           PoneEnMFile(Buff2);

           // Ahora leer hasta: 1) que termine el nodo o 2) que termine el file
           // o 3) Que aparezca un men
           AgregaTexto1(&o);
          }
        else
          {
           do
            {
             TomarLinea(hc);
            }
           while (strncmp(Buff,"* Menu",6)!=0 && !feof(hc));
           SaltearEspacios(hc);
           do
            {
             TomarLinea(hc);
             if (Buff[0]=='*')
               {
                SepararNombreYNodo(sNombreNodo,Buff2,Buff);
                NGShort *ObjReal=Lp.Buscar(Buff2);
                if (ObjReal!=NULL)
                  {
                   LargoAcum+=strlen(sNombreNodo);
                   if (LargoAcum>12000)
                     {
                      NGVariosShort *NueInd= new NGVariosShort(S_Contin);
                      Indice->Agregar(*NueInd,Lp);
                      Indice=NueInd;
                      LargoAcum=strlen(sNombreNodo);
                      printf(S_IndMuy,Entradas);
                      Entradas=0;
                     }
                   Entradas++;
                   NGShortDummy *Titulo= new NGShortDummy(sNombreNodo,Buff2,ObjReal);
                   Indice->Agregar(*Titulo,Lp);
                  }
                else
                   printf(S_NoEnCo,Buff2);
               }
            }
           while (!feof(hc) && Buff[0]!=31);
          }
       }
    }
 if (LargoAcum==0) // No hay ndice?
   {
    UnTitulo = new NGShort(S_NoDisp);
    Indice->Agregar(*UnTitulo,Lp);
   }
}


void CompilarArchivo(char *NomArch,NGVariosShort& Padre,NGListaPura& Lp)
{
 FILE *f=AbrirArchivo(NomArch,"rt");

 fgets(Buff,256,f);
 while(!feof(f))
   {
    if (strncmp(Buff,"!Short:",7)==0)
      {// OK crear un tipo 1
       Buff[strlen(Buff)-1]=0;
       NGShort *o = new NGShort(&Buff[7]);
       fgets(Buff,256,f);
       if (!(strncmp(Buff,"!Short:",7)==0)) // Separador
         {
          if (strncmp(Buff,"!SeeAlso:",9)==0)
            {
             char *aux;

             strtok(Buff,":");
             while ((aux=strtok(NULL,":"))!=NULL)
               {
                int l=strlen(aux)-1;
                if (aux[l]=='\n')
                   aux[l]=0;
                o->AgregarSeeAlso(aux);
               }
             fgets(Buff,256,f);
            }
          RebobinaMFile();
          do
           {
            PoneEnMFile(Buff);
            fgets(Buff,256,f);
           }
          while(Buff[0]!='!' && !feof(f));
          o->PonerTexto(BufMFile,uiLineasMFile);
         }
       Padre.Agregar(*o,Lp);
      }
   }
 fclose(f);
}


void Traducir(char *nom,char *nomng,char *nomdef)
{
 FILE *hOri=AbrirArchivo(nom,FOPEN_READ);

 if (!BuscarSiDiceNombre(hOri))
   {
    printf(S_AtNomb);
    PesadoSi(strlen(nomdef)>NOM_MAX,"Traducir");
    strcpy(sNombreArchivo,nomdef);
    strcpy(sNombreGuia,nomdef);
    LineasAExcluirCopy=0;
   }
 fseek(hOri,0,SEEK_SET);
 CrearIndice(hOri);

 #ifdef TEXTO_EN_DISCO
 fTemp=AbrirArchivo("__infa__.tmp","wb");
 #endif

 // Crear el archivo
 NGArchivo Ar(nomng,sNombreGuia);
 CopiarCredito(Ar,hOri);

 // Crear menes
 NGMenu M1("Copyright");
 NGMenu M2(S_Conten);
 Ar.Agregar(M1);
 Ar.Agregar(M2);

 // Crear sus opciones
 NGVariosShort M11(""); // Sin nombre por desprenderse de un men
 M1.Agregar(M11,S_Texto,Lp);
 NGVariosShort M21(""); // Sin nombre por desprenderse de un men
 M2.Agregar(M21,S_Menues,Lp);
 NGVariosShort M22(""); // Sin nombre por desprenderse de un men
 M2.Agregar(M22,S_Indice,Lp);
 
 // Meter el copyright
 NGShort M111("Copyright");
 fseek(hOri,0,SEEK_SET);
 RebobinaMFile();
 if (LineasAExcluirCopy)
    while (LineasAExcluirCopy--) TomarLinea(hOri);
 do
  {
   TomarLinea(hOri);
   if (Buff[0]!=31)
      PoneEnMFile(Buff);
  }
 while (Buff[0]!=31);
 PonerTexto(&M111,BufMFile,uiLineasMFile);
 M11.Agregar(M111,Lp);
 
 // Agregar desde un archivo fuente
 CompilarArchivo("GInf." S_IDIO,M11,Lp);

 // Ahora si, todo.
 hc=hOri;
 Nodos[0].FueAgregado=1;
 ConvertirTodo(M21,Nodos[0].TieneMenu);
 AgregarSueltos(M21,&M22);

 // Linkear
 printf(S_ResoRe);
 printf(S_LargoTot,Ar.ResolverPosiciones(0));
 Lp.ResolverPosiciones();
 FILE *f;
 Ar.Grabar(0,f);

 #ifdef TEXTO_EN_DISCO
 fclose(fTemp);
 remove("__infa__.tmp");
 #endif

 fclose(hOri);
}

int main(int argc, char *argv[])
{
 clock_t t1,t2;
 printf(S_NomPrg);

 t1=clock();

 if (argc!=4)
   {
    printf(S_Uso,argv[0]);
    return 1;
   }
 printf(S_ConcaA);
 Concatenar(argv[1],argv[2]);
 Traducir(argv[2],argv[3],argv[1]);

 t2=clock();
 printf(S_Tiempo,(float)(t2-t1)/CLOCKS_PER_SEC);

 return 0;
}