/* getcurdir.c -- get current directory
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"
#include <ctype.h>

WORD	process_get_current_directory(
		IN OUT LPSTR lpPathName,
		IN BYTE nDriveNum)	//< 64 logical drive
					//> 64	current logical drive
{
	WORD result;
	char lpszNewPath[MAX_PATHNAME_SIZE];
	char lpszNewDir[]= "C:\\";	

	PROLOG(process_get_current_directory);
	if (nDriveNum < 1) {
		EPILOG(process_get_current_directory,TRUE);			
		return ERROR_INVALID_DRIVE;
	}
	IS_NULL(lpPathName, ERROR_SUCCESS);
	IS_MAX_PATH_SIZE(lpPathName);

        DBGVALUE(lpPathName,"%s");
        DBGVALUE(nDriveNum,"%d");
	
	lpszNewPath[0] = '\0';
	lpszNewDir[0]= (nDriveNum >= 64)?(nDriveNum-64+'A'):(nDriveNum-1+'A');
	lstrcpy(lpszNewPath, lpszNewDir);
	lstrcat(lpszNewPath, lpPathName);
        DBGVALUE(lpszNewPath,"%s");

	if (nDriveNum >= 64) {	
//	drivenum is current drive
		if (!SetCurrentDirectory(lpszNewPath)) {
			result = (WORD)GetLastError();
			DBGMSG("GetCurDir call failed 1");
			DBGVALUE(lpszNewPath,"%s");	
			EPILOG(process_get_current_directory, FALSE);
			return result;
		}
	} else {
		char lpszOrgPath[MAX_PATHNAME_SIZE];
		if ((result = ValidDriveName(lpszNewDir, FALSE)))  {
			DBGMSG("GetCurDir, driver not present");
			DBGVALUE(lpszNewDir,"%s");	
			EPILOG(process_get_current_directory, FALSE);
			return result;
		}        
//Save path of the default drive 
		if (!GetCurrentDirectory(MAX_PATHNAME_SIZE ,lpszOrgPath)) {
			result = (WORD)GetLastError();
			DBGMSG("GetCurDir call failed 5");
			DBGVALUE(lpszOrgPath,"%s");	
			EPILOG(process_get_current_directory, FALSE);
			return result;
		}
		DBGVALUE(lpszOrgPath,"%s");
//make driver in sync with DOS part driver
		if (!SetCurrentDirectory(lpszNewPath)) {
			result = (WORD)GetLastError();
			DBGMSG("GetCurDir call failed 6");
			DBGVALUE(lpszNewPath,"%s");	
			EPILOG(process_get_current_directory, FALSE);
			return result;
		}
//if NewPath[ and OrgPath not on the same drive then restore to previous drive
		if (ttoupper(lpszOrgPath[0]) != ttoupper(lpszNewPath[0])) 
			if (!SetCurrentDirectory(lpszOrgPath)) {
				result = (WORD)GetLastError();
				DBGMSG("GetCurDir call failed 8");
				DBGVALUE(lpszOrgPath,"%s");	
				EPILOG(process_get_current_directory, FALSE);
				return result;
	       		}
	}
//retrieve longfile name
	if ((result = GetLongPathName_(lpszNewPath, lpszNewPath))) {
  		DBGMSG("Cannot generate long filename");
		DBGVALUE(lpszNewPath,"%s");	
		EPILOG(process_get_current_directory, TRUE);
		return result;
	}			

	lstrcpy(lpPathName,lpszNewPath+3);
	DBGVALUE(lpPathName,"%s");
	EPILOG(process_get_current_directory,TRUE);
	return ERROR_SUCCESS;	
}
