/* removedir.c -- remove directory
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_remove_directory(
		IN LPCSTR lpPathName)
{
	WORD result;
	PROLOG(process_remove_directory);
	IS_NULL(lpPathName, ERROR_PATH_NOT_FOUND);
	IS_MAX_PATH_SIZE(lpPathName);
	DBGVALUE(lpPathName,"%s");
	
	if (!RemoveDirectory(lpPathName)) {
		result = (WORD)GetLastError();
		if (result != ERROR_PATH_NOT_FOUND && result != ERROR_FILE_NOT_FOUND)
			DBGMSG("call failed");
	} else
		result = ERROR_SUCCESS;

	EPILOG(process_remove_directory, TRUE);
	return result;
}
