/* subst.c -- subst calls
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"
//
//	for substed drives the name is of type \??\X:
//	for persistent drives the name is of type \Device\Hatddisk0\Partition1\
//

WORD	process_handle_subst(
                IN OUT LPSTR lpPathName,
		IN BYTE nDriveNum,
		IN BYTE nAction)
{
	BOOL result;
	char lpszCurDir[]= "C:";
	char lpszPath[MAX_PATHNAME_SIZE];

	PROLOG(process_handle_subst);
	DBGVALUE(nDriveNum,"%d");
	DBGVALUE(nAction,"%d");

	if (nDriveNum == 0) {
		if (nAction != LONG_HANDLE_SUBST_CREATE) {
			EPILOG(process_handle_subst,TRUE);
			return ERROR_PATH_NOT_FOUND;
		}
		IS_NULL(lpPathName, ERROR_PATH_NOT_FOUND);
		IS_MAX_PATH_SIZE(lpPathName);
		DBGVALUE(lpPathName,"%s");

		if (!GetCurrentDirectory(MAX_PATHNAME_SIZE ,lpszPath)) {
			result = (WORD)GetLastError();
			DBGMSG("GetCurDir call failed");
			EPILOG(process_handle_subst,FALSE);
			return result;
		}
		lpszCurDir[0]=lpszPath[0];
	} else
		lpszCurDir[0]= nDriveNum-1+'A';

	DBGVALUE(lpszCurDir,"%s");
 
	switch (nAction)
	{
		case LONG_HANDLE_SUBST_CREATE:
			if (!DefineDosDevice(0,lpszCurDir, lpPathName)) { 
				result = (WORD)GetLastError();
				EPILOG(process_handle_subst,FALSE);
				return result;
			}
			break;
		case LONG_HANDLE_SUBST_TERMINATE:
			if (!QueryDosDevice(lpszCurDir, lpszPath, MAX_PATHNAME_SIZE)) {
				result = (WORD)GetLastError();
				EPILOG(process_handle_subst,FALSE);
				return result;
			}

			if (lpszPath[0] == '\\' && lpszPath[1] == '?' && 
	  		    lpszPath[2] == '?'  && lpszPath[3] == '\\') {
				if (!DefineDosDevice(DDD_REMOVE_DEFINITION, lpszCurDir, NULL)) {
					result = (WORD)GetLastError();
					EPILOG(process_handle_subst,FALSE);
					return result;
				}
			} else {
				EPILOG(process_handle_subst, TRUE);
				return ERROR_INVALID_DRIVE; 
			}	
			break;
		case LONG_HANDLE_SUBST_QUERY:
			if (!QueryDosDevice(lpszCurDir, lpszPath, MAX_PATHNAME_SIZE)) {
				result = (WORD)GetLastError();
				EPILOG(process_handle_subst,FALSE);
				return result;
			}

			if (lpszPath[0] == '\\' && lpszPath[1] == '?' && 
	  		    lpszPath[2] == '?'  && lpszPath[3] == '\\') {
				if (lpPathName) {
					lpszPath[4] = ttoupper(lpszPath[4]);
					lstrcpy(lpPathName, &lpszPath[4]);     			
					DBGVALUE(lpPathName,"%s");
				}
			} else {
				EPILOG(process_handle_subst, TRUE);
				return ERROR_INVALID_DRIVE; 
			}	
	      		break;
		default:
			EPILOG(process_handle_subst, TRUE);
			return ERROR_INVALID_FUNCTION; 
        }

	EPILOG(process_handle_subst, TRUE);
	return ERROR_SUCCESS;	
}
