/*
 * CMOS.CPP - Contains CMOS functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _CMOS_CC_

#include "cmos.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 unsigned char rtcdata[256];
 int f, flags;
 union REGS regs;
 struct SREGS segs;

 // Create output file.
 if ((fp = fopen("cmos.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nCMOS INFORMATION :\n\n");

 // Check if RTC is installed.
 // Get ROM table.
 regs.h.ah = 0xc0;
 int86x(0x15, &regs, &regs, &segs);
 // Check directly if not found (not perfect although).
 if (regs.x.flags & 1) {
    char rtctime;
    outportb(0x70, 0);
    rtctime = inportb(0x71);
    delay(2000);
    outportb(0x70, 0);
    if (inportb(0x71) == rtctime) {
       writestring("\tReal Time Clock not Installed.\n");
       fclose(fp);
       return 0;
    }
 }
 else {
      // Check from ROM table.
      if (peek(segs.es, regs.x.bx) >= 3) {
	 // Entry exists in ROM table.
	 if ((!(peekb(segs.es, regs.x.bx + 4) & 0x20)) && (regs.h.ah)) {
	    writestring("\tReal Time Clock not Installed.\n");
	    fclose(fp);
	    return 0;
	 }
      }
 }
 // RTC is installed.
 writestring("\tReal Time Clock Installed              : Yes\n");

 // Get RTC information.
 for(f = 0; f <= 256; f++)
 {
  outportb(0x70, f);
  rtcdata[f] = inportb(0x71);
 }

 // Check if battery is dead.
 if ((!(rtcdata[0xd] & 0x80)) || (rtcdata[0xe] & 0x80)) {
    writestring("\tPower Condition                        : Battery is dead\n");
    fclose(fp);
    return 0;
 }

 // Write information.
 writestring("\tPower Condition                        : Good\n");
 flags = rtcdata[0xe];
 sprintf(output,"\tCMOS Checksum                          : %s\n",
                        (flags & 64) ? "Invalid" : "Correct");
 writestring(output);
 sprintf(output,"\tCMOS Equipment Configuration           : %s\n",
                        (flags & 32) ? "Invalid" : "Correct");
 writestring(output);
 sprintf(output,"\tCMOS Memory Size                       : %s\n",
                        (flags & 16) ? "Invalid" : "Correct");
 writestring(output);
 sprintf(output,"\tDisk Controller Initialization status  : %s\n",
                        (flags & 8) ? "Failed" : "OK");
 writestring(output);
 sprintf(output,"\tCMOS Time Valid                        : %s\n",
                        (flags & 4) ? "No" : "Yes");
 writestring(output);
 sprintf(output,"\tAdaptor Configuration                  : %s\n",
			(flags & 2) ? "Invalid" : "OK");
 writestring(output);
 // FDD controller info.
 flags = (rtcdata[0x10] & 0xf0) >> 4;
 sprintf(output,"\tFDD Controller 1 in CMOS               : %s\n",
                       (!flags) ? "None":
                       (flags == 1) ? "360K - 5 and 1/4 Inch":
                       (flags == 2) ? "1.2M - 5 and 1/4 Inch":
                       (flags == 3) ? "720K - 3 and 1/2 Inch":
                       (flags == 4) ? "1.44M - 3 and 1/2 Inch":
                       (flags == 5) ? "2.88M - 3 and 1/2 Inch":
                       "Unknown");
 writestring(output);
 flags = rtcdata[0x10] & 0xf;
 sprintf(output,"\tFDD Controller 2 in CMOS               : %s\n",
                       (!flags) ? "None":
                       (flags == 1) ? "360K - 5 and 1/4 Inch":
                       (flags == 2) ? "1.2M - 5 and 1/4 Inch":
                       (flags == 3) ? "720K - 3 and 1/2 Inch":
                       (flags == 4) ? "1.44M - 3 and 1/2 Inch":
                       (flags == 5) ? "2.88M - 3 and 1/2 Inch":
                       "Unknown");
 writestring(output);
 // Calculate checksum;
 flags = rtcdata[0x2e] * 0x100;
 flags += rtcdata[0x2f];
 sprintf(output,"\tCMOS Checksum                          : %04Xh\n",
                        flags);
 writestring(output);

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

// The main function.
int main(int argc, char **argv)
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
