/*
 * INDICATE.CPP - Displays the indicator when running modules.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>

#define INDICATORSIZE 10

int indicatorrunning = 0;

void interrupt (*old_indicator_interrupt)(...);

int indicator_x = 22, indicator_y = 10;

char indicator_buf[INDICATORSIZE];
unsigned video_base = 0xb800;

void interrupt indicator_interrupt(...)
{
	static int counter = 0, iteration = 0;
	char *ptr = (char *)MK_FP(video_base, 0);
	unsigned offset = (indicator_y - 1) * 160 + (indicator_x - 1) * 2;
	int f;
	iteration++;
	if (iteration == 2) {
		iteration = 0;
		if (counter == INDICATORSIZE - 2) {
			// Clear entire area.
			for(f = 0; f < INDICATORSIZE; f++)
			ptr[offset + f * 2] = 32;
			// Draw brace;
			ptr[offset] = '[';
			ptr[offset + (INDICATORSIZE - 1) * 2] = ']';
			counter = 0;
		}
		else {
			ptr[offset + counter * 2 + 2] = '*';
			counter++;
		}
	}
	old_indicator_interrupt(...);
}

void start_indicator()
{
	// Save into buffer.
	int f;
	char *ptr = (char *)MK_FP(video_base, 0);
	unsigned offset = (indicator_y - 1) * 160 + (indicator_x - 1) * 2;
	for(f = 0; f < INDICATORSIZE; f++)
	indicator_buf[f] = ptr[offset + f * 2];

	// Draw braces,
	ptr[offset] = '[';
	ptr[offset + (INDICATORSIZE - 1) * 2] = ']';
	old_indicator_interrupt = getvect(8);
	setvect(8, indicator_interrupt);
	indicatorrunning++;
}

void stop_indicator()
{
	// Restore buffer;
	int f;
	char *ptr = (char *)MK_FP(video_base, 0);
	unsigned offset = (indicator_y - 1) * 160 + (indicator_x - 1) * 2;
	if (!indicatorrunning) return;
	for(f = 0; f < INDICATORSIZE; f++)
	ptr[offset + f * 2] = indicator_buf[f];
	setvect(8, old_indicator_interrupt);
	indicatorrunning--;
}