/*
 * KBD.CPP - Contains Keyboard handling functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * Special thanks to Al Williams.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _KBD_CC_

#include "kbd.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char vendorid[100], output[256];
 int i, result;
 union REGS regs;
 struct SREGS segs;
 long unsigned int address;

 // Create output file.
 if ((fp = fopen("kbd.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nKEYBOARD INFORMATION :\n\n");

 i = 0;
 do {
    i++;
    result = kbdinstalled();
 } while ((!result) && (i < 0x1b));

 // Check if keyboard is installed.
 sprintf(output, "\tKeyboard Installed                     : %s\n",
		 ((i < 256) && (result == 0xfa)) ? "Yes" : "No");
 writestring(output);
 // Delay, or else typematic rate won't be set !
 delay(500);

 // Get ROM table.
 regs.h.ah = 0xc0;
 int86x(0x15, &regs, &regs, &segs);
 if (!(regs.x.flags & 1)) {
    // ES:BX is pointing to ROM table.
    if (peek(segs.es, regs.x.bx) >= 5) {
       // Check if entry exists in ROM table.
       char flags = peekb(segs.es, regs.x.bx + 6);
       sprintf(output, "\tKeyboard Controller Hardware           : %s\n",
		       (flags & 4) ? "Non-8042" : "8042 Compatible");
       writestring(output);

       // See if typematic rate setting is supported.
       sprintf(output, "\tINT 16h, AH=09h Supported              : %s\n",
		       (flags & 0x40) ? "Yes" : "No");
       writestring(output);
    }
    if (peek(segs.es, regs.x.bx) >= 4) {
       char flags = peekb(segs.es, regs.x.bx + 5);
       sprintf(output, "\tKeyboard Intercept Support             : %s\n",
		       (flags & 0x10) ? "Yes" : "No");
       writestring(output);
    }
 }

 // Reset typematic rate if supported.
 regs.x.ax = 0x305;
 regs.x.bx = 0;
 int86(0x16, &regs, &regs);

 // Write keyboard controller type.
 sprintf(output, "\tKeyboard Controller type               : %s\n",
		 (peekb(0, 0x496) & 0x10) ?
		 "Enhanced" :
		 "Standard");
 writestring(output);

 // Get vendorid.
 memset(vendorid, 0, 100);
 address = get_vendor_id(vendorid) - FP_OFF(vendorid);
 vendorid[address] = 0;
 sprintf(output, "\tKeyboard Layout ID                     : %Xh\n",
		 (unsigned)vendorid[0]);
 writestring(output);
 sprintf(output, "\tKeyboard Vendor Name                   : %s\n",
		 &vendorid[1]);
 writestring(output);

 // Write BIOS keyboard buffer information.
 sprintf(output, "\tKeyboard Buffer Head Pointer           : 0040:%04Xh\n",
		 peek(0, 0x41a));
 writestring(output);
 sprintf(output, "\tKeyboard Buffer Tail Pointer           : 0040:%04Xh\n",
		 peek(0, 0x41c));
 writestring(output);
 strcpy(output, "\tDefault Keyboard Buffer                : 0040:001Eh\n");
 writestring(output);

 // Write LED status.
 sprintf(output, "\tBIOS Keyboard LED Status (SCROLL LOCK) : %s\n",
		 (peek(0, 0x417) & 0x10) ? "Yes" : "No");
 writestring(output);
 sprintf(output, "\tBIOS Keyboard LED Status (NUM LOCK)    : %s\n",
		 (peek(0, 0x417) & 0x20) ? "Yes" : "No");
 writestring(output);
 sprintf(output, "\tBIOS Keyboard LED Status (CAPS LOCK)   : %s\n",
		 (peek(0, 0x417) & 0x40) ? "Yes" : "No");
 writestring(output);

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

// The main function.
int main(int argc, char **argv)
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
