; * KBDA.ASM - Contains Keyboard low level handling functions.
; * Copyright (C) 1998, 1999 Prashant TR
; *
; * This program is free software; you can redistribute it and/or modify
; * it under the terms of the GNU General Public License as published by
; * the Free Software Foundation; either version 2 of the License, or
; * (at your option) any later version.
; *
; * See the file COPYING.TR for more details.

; ID for this file.

; Global functions.
PUBLIC _kbdinstalled
PUBLIC _get_vendor_id

IDELAY	MACRO
	LOCAL	DELAY1, DELAY2, DELAY3, DELAY4
	JMP	DELAY1
DELAY1:	JMP	DELAY2
DELAY2:	JMP	DELAY3
DELAY3:	JMP	DELAY4
DELAY4:
	ENDM


_TEXT	SEGMENT	BYTE PUBLIC 'CODE'
ASSUME CS:_TEXT
.386P

_keyout	PROC	NEAR
	MOV	CX, 0FFFFH
_keyout_loop:
	IN	AL, 64H
	TEST	AL, 2
	JZ      _keyout_ret
	LOOP    _keyout_loop
_keyout_ret:
	OR	CX, CX
	RET

_keyout	ENDP


_keyin	PROC	NEAR
	MOV	CX, 0FFFFH
_keyin_loop:
	IN	AL, 64H
	TEST	AL, 1
	JZ      _keyin_do_loop
	IN	AL, 60H
	JMP     _keyin_ret
_keyin_do_loop:
	LOOP    _keyin_loop
_keyin_ret:
	OR	CX, CX
	RET

_keyin	ENDP


_kbdinstalled	PROC	FAR
	PUSH	ECX
	XOR	DX, DX
	XOR	EAX, EAX
	CLI
	CALL    _keyout
	JZ      _no_kbd_installed
	MOV	AL, 0FFH
	OUT	60H, AL
	IDELAY
	CALL    _keyout
	JZ      _no_kbd_installed
	CALL    _keyin
	JZ      _no_kbd_installed
	POP	ECX
	OR	EAX, EAX
	JNZ	_return
	MOV	AX, 100H
_return:
	STI
	RET
_no_kbd_installed:
	POP	ECX
	XOR	EAX, EAX
	RET

_kbdinstalled	ENDP


_get_vendor_id	PROC	FAR
	PUSH	BP
	MOV	BP, SP
	PUSH	DS
	PUSH	CX
	PUSH	SI
	LDS	SI, [BP + 6]

	; Get 1st byte of vendor id.
	CLI
	CALL    _keyout
	JZ      _vendor_id_failed
	MOV	AL, 0A1H
	OUT	64H, AL
	CALL	_keyout
	JZ      _vendor_id_failed
	CALL	_keyin
	JZ      _vendor_id_failed
	MOV	[SI], AL
	INC	SI

	; Get the 2nd (or more) byte(s) of information.
	CALL	_keyout
	JZ      _vendor_id_failed
	MOV	AL, 0A0H
	OUT	64H, AL
	CALL	_keyout
	JZ      _vendor_id_failed
	MOV	CX, 1BH

	; Get the information.
_vendor_id_getid:
	CALL	_keyin
	JZ      _vendor_id_failed
	MOV	[SI], AL
	INC	SI
	LOOP	_vendor_id_getid

_vendor_id_failed:
	STI
	MOV	AX, SI
	POP	SI
	POP	CX
	POP	DS
	POP	BP
	XOR	DX, DX
	RET

_get_vendor_id	ENDP

_TEXT	ENDS
	END
