/*
 * SYSFILES.C - Contains functions to get system files.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _SYSFILES_CC_

#include "sysfiles.h"

int errflag = 0;
FILE *fp;
char cmdline[20];
char output[256];
char winpath[50];
char rootpath[50];
extern char **environ;

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

void writesysfile(const char *path, const char *file)
{
 FILE *fp1;

 strcpy(output, path);
 strcat(output, file);

 // Write the filename.
 writestring("------------------------------------------------------------------------------\n");
 writestring(" LISTING OF ");
 writestring(file);
 writestring("\n");
 writestring("------------------------------------------------------------------------------\n");

 // Open the file.
 if ((fp1 = fopen(output, "rb")) == NULL) {
	writestring("\tUnable to open file.\n\n");
	return;
 }

 while (fgets(output, 255, fp1) != NULL)
 {
	while ((output[strlen(output) - 1] == '\r') ||
		(output[strlen(output) - 1] == '\n'))
		output[strlen(output) - 1] = 0;
	writestring(output);
	writestring("\n");
 }

 writestring("\n");
 fclose(fp1);
}

int sysinfo()
{
 char bootdrv;
 struct ffblk fblk;
 int f;
 __dpmi_regs regs;

 // Create output file.
 if ((fp = fopen("sysfiles.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 regs.x.ax = 0x3305;
 __dpmi_int(0x21, &regs);
 bootdrv = regs.h.dl;

 // See if booted from hard drive.
 if (bootdrv <= 2) return 0;
 winpath[0] = bootdrv + 'A' - 1;
 winpath[1] = '\0';
 strcpy(rootpath, winpath);
 strcat(rootpath, ":\\");
 strcat(winpath, ":\\WINDOWS");

  // Check if we have windows loaded.
 if (findfirst(winpath, &fblk, FA_DIREC | FA_HIDDEN | FA_RDONLY | FA_ARCH)) {
	writesysfile(rootpath, "AUTOEXEC.BAT");
	writesysfile(rootpath, "CONFIG.SYS");
 }
 else {
	strcat(winpath, "\\");
	writesysfile(rootpath, "AUTOEXEC.BAT");
	writesysfile(rootpath, "AUTOEXEC.DOS");
	writesysfile(rootpath, "CONFIG.SYS");
	writesysfile(rootpath, "CONFIG.DOS");
	writesysfile(winpath, "CONTROL.INI");
	writesysfile(rootpath, "MSDOS.SYS");
	writesysfile(rootpath, "NETLOG.TXT");
	writesysfile(winpath, "PROTOCOL.INI");
	writesysfile(rootpath, "SCANDISK.LOG");
	writesysfile(winpath, "SYSTEM.INI");
	writesysfile(winpath, "WIN.INI");
 }

 // Add environment.
 writestring("------------------------------------------------------------------------------\n");
 writestring(" LISTING OF ENVIRONMENT\n");
 writestring("------------------------------------------------------------------------------\n");
 f = 0;
 while (environ[f] != NULL)
 {
	writestring(environ[f++]);
	writestring("\n");
 }

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");
}

int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}