//----------------------------------------------------------------------------
//
// AATEXT 1.0 beta - Antialiased text fonts for Allegro
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//
// Antialiased text profiling program for different video modes
//
// Written by Doug Eleveld
//
//----------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>
#include <stream.h>
#include "allegro.h"
#include "aatext.h"
#include "penttime.h"

// General RGB map speeds up almost all 256 color stuff
RGB_MAP rgb_table;

//----------------------------------------------------------------------------
// Profile the video mode by plotting random text on the screen and
// time each of the routines
//----------------------------------------------------------------------------
void do_profile (int mode, int x, int y, int depth, int textmode)
   {
   cout << "Press space to profile " << x << "x" << y << " in " << depth << " bit mode with ";
   if(textmode<0) cout << "empty";
   else cout << "filled";
   cout << " background\n";
   cout.flush();
   while(key[KEY_SPACE]);
   while(!key[KEY_SPACE]);

   // Try and set the requested mode
   set_color_depth(depth);
   if(set_gfx_mode(mode,x,y,0,0)!=0)
      {
      // Warn that the mode did not work
      set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
      printf("Could not set graphics mode.\n");

      return;
      }

   // Load the font data in
   FONT* thefont = load_font("font.pcx");
   if(thefont == NULL)
      {
      set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
      cerr << "Could not load font data from font.pcx\n";
      exit(0);
      }

   // Create the color maps and RGB table for the antialiased fonts
   PALETTE pal;
   generate_332_palette(pal);
   set_palette(pal);

   // Make sure that we have black as colour zero
   RGB black = {0,0,0};
   set_color(0,&black);

   create_rgb_table(&rgb_table,pal,NULL);
   rgb_map = &rgb_table;

   // Initialise the antialiased palette
   antialias_init(pal);

   // Draw background
   clear_to_color(screen,makecol(0,0,0));
   text_mode(textmode);

   // Setup the profilers
   pentium_profiler alleg_profile;
   pentium_profiler dougs_profile;

   // Randomly plot stuff to the screen
   while(!key[KEY_ESC])
//   for(int u=0;u<10;u++)
      {
      // Do the normal Allegro stuff
      textout_centre(screen,thefont,"Press escape to quit.", rand()%x, rand()%y, rand()%(1<<depth));
      alleg_profile.start();
      textout_centre(screen,thefont,"Press escape to quit.", rand()%x, rand()%y, rand()%(1<<depth));
      alleg_profile.stop();

      // Do the antialiased stuff
      aatextout_center(screen,thefont,"Press escape to quit.", rand()%x, rand()%y, rand()%(1<<depth));
      dougs_profile.start();
      aatextout_center(screen,thefont,"Press escape to quit.", rand()%x, rand()%y, rand()%(1<<depth));
      dougs_profile.stop();
      }
//	while(key[KEY_SPACE]);
//	while(!key[KEY_SPACE]);

   // Display profiling info
   set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
   cout << "Profiling results for " << x << "x" << y << " in " << depth << " bit mode with ";
   if(textmode<0) cout << "empty";
   else cout << "filled";
   cout << " background\n";

   cout << "Allegro's textout average number of clock cycles: " << alleg_profile.cycles() << endl;
   cout << "   Doug's textout average number of clock cycles: " << dougs_profile.cycles() << endl;

   cout << "\nPress space to continue.\n";
   cout.flush();
	while(key[KEY_SPACE]);
	while(!key[KEY_SPACE]);

   // Close up shop and exit
   antialias_exit();
   destroy_font(thefont);
   }

//----------------------------------------------------------------------------
// Profile the video mode by in some different video modes
//----------------------------------------------------------------------------
int main (void)
   {
   cout << "\n\n\n\n\n\nAntialiased text drawing profiler for Allegro by Doug Eleveld\n\n"
           "This profiles the speed of drawing antialiased text using a few different\n"
           "video modes and color depths.  It requires a pentium computer because I\n"
           "used the internal pentium timer to check the text drawing speed.  The \n"
           "antialiased-routines are usually from 1.5 to about 8 times slower than the\n"
           "normal allegro textout stuff.\n";

   // Setup Allegro and some internal stuff
	allegro_init();

   // Make sure we have a pentium
   check_cpu();
   if(cpu_family!=5)
      {
      cerr << "Sorry, you need a pentium computer to run this program.\n";
      exit(0);
      }

	if(install_keyboard() != 0)
	   {
		cerr << "Could not install keyboard.\n";
		exit(0);
	   }

   // Profile the basic 8 bit mode filled background
   do_profile(GFX_AUTODETECT,320,200,8,0);

   // Profile the basic 8 bit mode empty background
   do_profile(GFX_AUTODETECT,320,200,8,-1);

   // Profile the basic 8 bit mode filled background
   do_profile(GFX_AUTODETECT,640,480,8,0);

   // Profile the basic 8 bit mode empty background
   do_profile(GFX_AUTODETECT,640,480,8,-1);

   // Profile the basic 15 bit mode filled background
   do_profile(GFX_AUTODETECT,640,480,15,0);

   // Profile the basic 15 bit mode empty background
   do_profile(GFX_AUTODETECT,640,480,15,-1);

   // Profile the basic 16 bit mode filled background
   do_profile(GFX_AUTODETECT,640,480,16,0);

   // Profile the basic 16 bit mode empty background
   do_profile(GFX_AUTODETECT,640,480,16,-1);

   // Profile the basic 24 bit mode filled background
   do_profile(GFX_AUTODETECT,640,480,24,0);

   // Profile the basic 24 bit mode empty background
   do_profile(GFX_AUTODETECT,640,480,24,-1);

   // Profile the basic 32 bit mode filled background
   do_profile(GFX_AUTODETECT,640,480,32,0);

   // Profile the basic 32 bit mode empty background
   do_profile(GFX_AUTODETECT,640,480,32,-1);

	allegro_exit();

   return 0;
   }


