indexing
    description    : "Allegro con Eiffel: ace file tools objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : ace_file_tools
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


expanded class ACE_FILE_TOOLS


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON

    FILE_TOOLS   -- implementation inheritance
    end          -- inherit FILE_TOOLS


------------------------------------------------------ ACE_FILE_TOOLS features
feature { ANY }

    name(pth : STRING) : STRING is
    -- Return just the name portion of the specified path
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
    local
        p1 : POINTER
        p2 : POINTER
    do
        p1 := pth.to_external
        !!Result.make(256)
        c_inline_c("_p2=get_filename(_p1);")
        Result.from_external(p2)
        Result.right_adjust
    end  -- feature name


    extension(pth : STRING) : STRING is
    -- Return just the extension portion of the specified path
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
    local
        p1 : POINTER
        p2 : POINTER
    do
        p1 := pth.to_external
        !!Result.make(256)
        c_inline_c("_p2=get_extension(_p1);")
        Result.from_external(p2)
        Result.right_adjust
    end  -- feature extension


    exists(pth : STRING) : BOOLEAN is
    -- Returns true if the specified file exists
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
    local
        p : POINTER
    do
        p := pth.to_external
        c_inline_c("R=(exists(_p)==0?0:-1);")
    end  -- feature exists


    size(pth : STRING) : INTEGER is
    -- Returns the size of the specified file
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
        path_exists     : exists(pth)
    local
        p : POINTER
    do
        p := pth.to_external
        c_inline_c("R=file_size(_p);")
    end  -- feature size


    date(pth : STRING) : INTEGER is
    -- Returns the modification date/time of the specified file
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
        path_exists     : exists(path)
    local
        p : POINTER
    do
        p := pth.to_external
        c_inline_c("R=file_time(_p);")
    end  -- feature date


    delete(pth : STRING) : INTEGER is
    -- Deletes the specified file
    require
        ace_initialised : info.ace_initialised
        path_is_valid   : pth /= Void
        path_exists     : exists(pth)
    local
        p : POINTER
    do
        p := pth.to_external
        c_inline_c("R=delete_file(_p);")
    end  -- feature delete


end  -- class ACE_FILE_TOOLS
