indexing
    description    : "Allegro con Eiffel: planar_compiled_sprite objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : planar_compiled_sprite
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class PLANAR_COMPILED_SPRITE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    make(bitmap : BITMAP) is
    -- Create a new planar_compiled_sprite from the specified file
    require
        ace_initialised : info.ace_initialised
        bitmap_is_valid : bitmap /= Void and then
                          bitmap.is_valid and then
                          bitmap.is_memory
    local
        p : POINTER
    do
        if is_valid then
            discard
        end  -- if

        p := bitmap.data
        c_inline_c("C->_data=get_compiled_sprite(_p,TRUE);")
    ensure
        is_valid : is_valid
    end  -- feature make


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a planar_compiled_sprite from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid : is_valid
    end  -- feature make_from_external


------------------------------------------------------ Internal features (PLANAR_COMPILED_SPRITE)
feature { PLANAR_COMPILED_SPRITE }

    data : POINTER


------------------------------------------------------ PLANAR_COMPILED_SPRITE features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this planar_compiled_sprite is valid or not
    do
        Result := data.is_not_void
    end  -- feature is_valid


    discard is
    -- Discard this planar_compiled_sprite
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("destroy_compiled_sprite(C->_data);C->_data=NULL;")
    ensure
        not_valid : not is_valid
    end  -- feature discard


    width : INTEGER is
    -- Return the width of this planar_compiled_sprite
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    do
        c_inline_c("R=((COMPILED_SPRITE *)(C->_data))->w;")
    end  -- feature width


    height : INTEGER is
    -- Return the height of this planar_compiled_sprite
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    do
        c_inline_c("R=((COMPILED_SPRITE *)(C->_data))->h;")
    end  -- feature height


    blit(bitmap : BITMAP; x, y : INTEGER) is
    -- Blit this planar_compiled_sprite to the specified bitmap
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
        bitmap_is_valid      : bitmap /= Void and then
                               bitmap.is_valid
        x_is_valid           : x >= 0 and
                               x <= bitmap.width - width
        y_is_valid           : y >= 0 and
                               y <= bitmap.height - height
    local
        p : POINTER
    do
        p := bitmap.data
        c_inline_c("draw_compiled_sprite(_p,C->_data,a2,a3);")
    end  -- feature blit


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies data.is_not_void and
                  not is_valid implies data.is_void


end  -- class PLANAR_COMPILED_SPRITE
