indexing
    description    : "Allegro con Eiffel: soundcard objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : soundcard
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class SOUNDCARD


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end  -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make is
    -- Create a new soundcard
    require
        ace_initialised : info.ace_initialised
    do
        digital_volume := -1
        midi_volume    := -1
    ensure
        digital_volume_is_valid : digital_volume = -1
        midi_volume_is_valid    : midi_volume = -1
    end  -- feature make


------------------------------------------------------ Soundcard features
feature { ANY }

    init(digital, midi : INTEGER) : BOOLEAN is
    -- Initialise the sound card
    require
        ace_initialised         : info.ace_initialised
        digital_driver_is_valid : digital = info.digital_none                    or
                                  digital = info.digital_autodetect              or
                                  digital = info.digital_autodetect_soundblaster or
                                  digital = info.digital_soundblaster_1          or
                                  digital = info.digital_soundblaster_1_5        or
                                  digital = info.digital_soundblaster_2          or
                                  digital = info.digital_soundblaster_pro        or
                                  digital = info.digital_soundblaster_16
--                                  digital = info.digital_gus  -- not written yet
        midi_driver_is_valid    : midi = info.midi_none       or
                                  midi = info.midi_autodetect or
                                  midi = info.midi_adlib      or
                                  midi = info.midi_opl2       or
                                  midi = info.midi_2xopl2     or
                                  midi = info.midi_opl3       or
                                  midi = info.midi_sb_out     or
                                  midi = info.midi_mpu
--                                  midi = info.midi_gus        or  -- not written yet
--                                  midi = info.midi_digmid         -- not written yet
    do
        c_inline_c("R=(install_sound(a1,a2,NULL)==0?-1:0);")

        if Result then
            info.set_soundcard_flag(TRUE)
            info.set_digital_driver(digital_driver)
            info.set_midi_driver(midi_driver)
        else
            info.set_soundcard_flag(FALSE)
            info.set_digital_driver(info.digital_none)
            info.set_midi_driver(info.midi_none)
        end  -- if
    ensure
        result_is_valid : Result implies info.soundcard_initialised
    end  -- feature init


    auto_init : BOOLEAN is
    -- Autodetect and initialise the sound card
    require
        ace_initialised : info.ace_initialised
    do
        Result := init(info.digital_autodetect, info.midi_autodetect)
    end  -- feature auto_init


    set_digital_volume(volume : INTEGER) is
    -- Set the global digital driver volume
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        volume_is_valid       : volume >= 0 and volume <= 255
    do
        c_inline_c("set_volume(a1,C->_midi_volume);")
        digital_volume := volume
    ensure
        digital_volume_is_valid : digital_volume = volume
    end  -- feature set_digital_volume


    digital_driver : INTEGER is
    -- Return the digital driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    do
        c_inline_c("R=digi_card;")
    ensure
        result_is_valid : Result = info.digital_none                    or
                          Result = info.digital_autodetect              or
                          Result = info.digital_autodetect_soundblaster or
                          Result = info.digital_soundblaster_1          or
                          Result = info.digital_soundblaster_1_5        or
                          Result = info.digital_soundblaster_2          or
                          Result = info.digital_soundblaster_pro        or
                          Result = info.digital_soundblaster_16
--                          Result = info.digital_gus  -- not written yet
    end  -- feature digital_driver


    digital_driver_name : STRING is
    -- Return the name of the digital driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    local
        p : POINTER
    do
        Result := temp_string
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, digi_driver->name);")
        Result.right_adjust
    end  -- feature digital_driver_name


    digital_driver_description : STRING is
    -- Return the description of the digital driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    local
        p : POINTER
    do
        Result := temp_string
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, digi_driver->desc);")
        Result.right_adjust
    end  -- feature digital_driver_description


    digital_voices : INTEGER is
    -- Return the number of voices the current digital driver supports
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    do
        c_inline_c("R=digi_driver->voices;");
    end  -- feature digital_voices


    -- The current volume of the digital output device
    digital_volume : INTEGER


    set_midi_volume(volume : INTEGER) is
    -- Set the global midi driver volume
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
        volume_is_valid       : volume >= 0 and volume <= 255
    do
        c_inline_c("set_volume(C->_digital_volume,a1);")
        midi_volume := volume
    ensure
        midi_volume_is_valid : midi_volume = volume
    end  -- feature set_midi_volume


    midi_driver : INTEGER is
    -- Return the midi driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    do
        c_inline_c("R=midi_card;")
    ensure
        Result_is_valid : Result = info.midi_none       or
                          Result = info.midi_autodetect or
                          Result = info.midi_adlib      or
                          Result = info.midi_opl2       or
                          Result = info.midi_2xopl2     or
                          Result = info.midi_opl3       or
                          Result = info.midi_sb_out     or
                          Result = info.midi_mpu
--                          Result = info.midi_gus        or  -- not written yet
--                          Result = info.midi_digmid         -- not written yet
    end  -- feature midi_driver


    midi_driver_name : STRING is
    -- Return the name of the midi driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    local
        p : POINTER
    do
        Result := temp_string
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, midi_driver->name);")
        Result.right_adjust
    end  -- feature midi_driver_name


    midi_driver_description : STRING is
    -- Return the description of the midi driver currently in use
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    local
        p : POINTER
    do
        Result := temp_string
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, midi_driver->desc);")
        Result.right_adjust
    end  -- feature midi_driver_description


    midi_voices : INTEGER is
    -- Return the number of voices the current midi driver supports
    require
        ace_initialised       : info.ace_initialised
        soundcard_initialised : info.soundcard_initialised
    do
        c_inline_c("R=midi_driver->voices;");
    end  -- feature midi_voices


    -- The current volume of the midi output device
    midi_volume : INTEGER


------------------------------------------------------ Internal features
feature { NONE }

    temp_string : STRING is
    once
        !!Result.make(128)
    end  -- feature temp_string


end  -- class SOUNDCARD
