indexing
    description    : "Allegro con Eiffel: pack_file_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : pack_file_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class PACK_FILE_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        write_file : PACK_FILE_WRITE
        read_file  : PACK_FILE_READ
        character  : CHARACTER
        string     : STRING
        integer    : INTEGER
        real       : REAL
        double     : DOUBLE
    do

--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if


--------------------------------------------------- Test pack_file_write routines

        -- Create a test.pak and put in some data
        !!write_file.connect_to("test.pak")
        write_file.put_character(character_const)
        write_file.put_new_line
        write_file.put_string(string_const)
        write_file.put_new_line
        write_file.put_integer(integer_const)
        write_file.put_new_line
        write_file.put_real(real_const)
        write_file.put_new_line
        write_file.put_double(double_const)
        write_file.put_new_line
        write_file.flush
        write_file.disconnect

        -- Read all data from test.pak
        !!read_file.connect_to("test.pak")
        read_file.read_character
        character := read_file.last_character
        read_file.read_line  -- Read newline after character
        read_file.read_line
        string    := clone(read_file.last_string)
        read_file.read_integer
        integer   := read_file.last_integer
        read_file.read_real
        real      := read_file.last_real
        read_file.read_double
        double    := read_file.last_double
        read_file.disconnect

        -- Now check that the values were correct
        if character /= character_const then
            crash_with_message("Characters not equal!")
        end  -- if

        if not string.is_equal(string_const) then
            crash_with_message("Strings not equal!")
        end  -- if

        if integer /= integer_const then
            crash_with_message("Integers not equal!")
        end  -- if

        if real /= real_const then
            io.put_character('%N')
            io.put_real(real)
            io.put_string(" /= ")
            io.put_real(real_const)
            crash_with_message("Reals not equal!")
        end  -- if

        if double /= double_const then
            io.put_character('%N')
            io.put_double(double)
            io.put_string(" /= ")
            io.put_double(double_const)
            crash_with_message("Doubles not equal!")
        end  -- if

        io.put_string("%NAll tests passed successfully:%N%N")

        io.put_character(character_const)
        io.put_character('=')
        io.put_character(character)
        io.put_character('%N')

        io.put_string(string_const)
        io.put_character('=')
        io.put_string(string)
        io.put_character('%N')

        io.put_integer(integer_const)
        io.put_character('=')
        io.put_integer(integer)
        io.put_character('%N')

        io.put_string(real_const.to_string_format(5))
        io.put_character('=')
        io.put_string(real.to_string_format(5))
        io.put_character('%N')

        io.put_string(double_const.to_string_format(12))
        io.put_character('=')
        io.put_string(double.to_string_format(12))
        io.put_character('%N')

    end  -- feature make

------------------------------------------------------ Internal features
feature { NONE }

    -- Constants to write to the file
    character_const : CHARACTER is 'T'
    string_const    : STRING is "This is a test of the Allegro packfile routines."
    integer_const   : INTEGER is 654321
    real_const      : REAL is 3.14159
    double_const    : DOUBLE is 2.718281828459


    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the allegro error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class PACK_FILE_TEST
