indexing
    description    : "Allegro con Eiffel: screen objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : screen
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class SCREEN


inherit
    BITMAP
        redefine width, height
    end  -- inherit BITMAP


------------------------------------------------------ Screen features
feature { ANY }

    width : INTEGER is
    -- Return the virtual width of the screen
    do
        c_inline_c("R=VIRTUAL_W;")
    end  -- feature width


    height : INTEGER is
    -- Return the virtual height of the screen
    do
        c_inline_c("R=VIRTUAL_H;")
    end  -- feature height


    visible_width : INTEGER is
    -- Return the visible width of the screen
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    do
        c_inline_c("R=SCREEN_W;")
    end  -- feature visible width


    visible_height : INTEGER is
    -- Return the visible height of the screen
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    do
        c_inline_c("R=SCREEN_H;")
    end  -- feature visible height


    driver : INTEGER is
    -- Return the driver currently in use
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    external
        "IC"
    ensure
        driver_is_valid : Result = info.graphics_text       or
                          Result = info.graphics_vga        or
                          Result = info.graphics_modex      or
                          Result = info.graphics_vesa1      or
                          Result = info.graphics_vesa2b     or
                          Result = info.graphics_vesa2l     or
                          Result = info.graphics_vbeaf      or
                          Result = info.graphics_xtended    or
                          Result = info.graphics_ati        or
                          Result = info.graphics_mach64     or
                          Result = info.graphics_cirrus64   or
                          Result = info.graphics_cirrus54   or
                          Result = info.graphics_paradise   or
                          Result = info.graphics_s3         or
                          Result = info.graphics_trident    or
                          Result = info.graphics_et3000     or
                          Result = info.graphics_et4000     or
                          Result = info.graphics_video7
    end  -- feature driver


    driver_name : STRING is
    -- Return the name of the driver currently in use
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    local
        p : POINTER
    once
        !!Result.make(128)
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, gfx_driver->name);")
        Result.right_adjust
    end  -- feature driver_name


    driver_description : STRING is
    -- Return the description of the driver currently in use
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        is_valid             : is_valid
    local
        p : POINTER
    once
        !!Result.make(128)
        Result.blank(127)
        p := Result.to_external
        c_inline_c("strcpy(_p, gfx_driver->desc);")
        Result.right_adjust
    end  -- feature driver_description


    init(video_driver, screen_width, screen_height, desired_virtual_width, desired_virtual_height : INTEGER ) : BOOLEAN is
    -- Initialise the screen
    require
        ace_initialised       : info.ace_initialised
        video_driver_is_valid : video_driver = info.graphics_text       or
                                video_driver = info.graphics_autodetect or
                                video_driver = info.graphics_vga        or
                                video_driver = info.graphics_modex      or
                                video_driver = info.graphics_vesa1      or
                                video_driver = info.graphics_vesa2b     or
                                video_driver = info.graphics_vesa2l     or
                                video_driver = info.graphics_vbeaf      or
                                video_driver = info.graphics_xtended    or
                                video_driver = info.graphics_ati        or
                                video_driver = info.graphics_mach64     or
                                video_driver = info.graphics_cirrus64   or
                                video_driver = info.graphics_cirrus54   or
                                video_driver = info.graphics_paradise   or
                                video_driver = info.graphics_s3         or
                                video_driver = info.graphics_trident    or
                                video_driver = info.graphics_et3000     or
                                video_driver = info.graphics_et4000     or
                                video_driver = info.graphics_video7
        desired_virtual_width_is_valid  : desired_virtual_width  = 0 or
                                  desired_virtual_width  >= screen_width
        desired_virtual_height_is_valid : desired_virtual_height = 0 or
                                  desired_virtual_height >= screen_height
    local
        p : POINTER
    do
        c_inline_c("R=(set_gfx_mode(a1,a2,a3,a4,a5)==0?-1:0);")

        if Result then
            info.set_graphics_driver(driver)
            info.set_graphics_flag(video_driver /= info.graphics_text)
            c_inline_c("_p=screen;")

            if video_driver /= info.graphics_text then
                data := p
            else
                c_inline_c("C->_data=NULL;")
            end  -- if
        end  -- if
    end  -- feature init


    auto_init(screen_width, screen_height, desired_virtual_width, desired_virtual_height : INTEGER ) : BOOLEAN is
    -- Initialise the screen
    require
        ace_initialised       : info.ace_initialised
        desired_virtual_width_is_valid  : desired_virtual_width  = 0 or
                                  desired_virtual_width  >= screen_width
        desired_virtual_height_is_valid : desired_virtual_height = 0 or
                                  desired_virtual_height >= screen_height
    do
        Result := init(info.graphics_autodetect, screen_width, screen_height,
                       desired_virtual_width, desired_virtual_height)
    end  -- feature auto_init


    shutdown is
    -- Shutdown the screen (restore text mode)
    require
        ace_initialised       : info.ace_initialised
        graphics_initialised  : info.graphics_initialised
        valid_graphics_driver : info.graphics_driver /= info.graphics_text
    local
        mode_set_success : BOOLEAN
    do
        mode_set_success := init(info.graphics_text, 0, 0, 0, 0)

        check
            mode_set_success : mode_set_success
        end  -- check mode_set_success
    ensure
        graphics_not_initialised : not info.graphics_initialised
        valid_graphics_driver    : info.graphics_driver = info.graphics_text
        not_is_valid             : not is_valid
    end


    vsync is
    -- Wait for a vertical retrace to begin
    require
        ace_initialised : info.ace_initialised
    external
        "IC"
    end  -- feature vsync


    retrace_count : INTEGER is
    -- Return the retrace count
    require
        ace_initialised   : info.ace_initialised
        timer_initialised : info.timer_initialised
    do
        c_inline_c("R=retrace_count;");
    end


    scroll(x, y : INTEGER) is
    -- Scrolls the screen to the given coordinates
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        graphics_driver_is_valid : info.graphics_driver /= info.graphics_text and
                                   info.graphics_driver /= info.graphics_vga
        x_is_valid           : x >= 0 and
                               x <= (width-visible_width)
        y_is_valid           : y >= 0 and
                               y <= (height-visible_height)
    local
        i : INTEGER
    do
        c_inline_c("_i=scroll_screen(a1,a2);")

        check
            scroll_success : i = 0
        end  -- check scroll_success
    end  -- feature scroll


    request_modex_scroll(x, y : INTEGER) is
    -- Request an asynchronous Mode-X screen scroll
    require
        ace_initialised          : info.ace_initialised
        graphics_initialised     : info.graphics_initialised
        graphics_driver_is_valid : info.graphics_driver = info.graphics_modex
        timer_initialised        : info.timer_initialised
        retrace_simulator_initialised : info.retrace_simulator_initialised
        x_is_valid               : x >= 0 and
                                   x <= (width-visible_width)
        y_is_valid               : y >= 0 and
                                   y <= (height-visible_height)
    external
        "IC"
    end  -- feature request_modex_scroll


    modex_scroll_waiting : BOOLEAN is
    -- Has the requested asynchronous Mode-X hardware scroll happened yet?
    require
        ace_initialised          : info.ace_initialised
        graphics_initialised     : info.graphics_initialised
        graphics_driver_is_valid : info.graphics_driver = info.graphics_modex
        timer_initialised        : info.timer_initialised
        retrace_simulator_initialised : info.retrace_simulator_initialised
    do
        c_inline_c("R=(poll_modex_scroll()!=0?0:1);")
    end  -- feature poll_modex_scroll


    modex_split(line : INTEGER) is
    -- Split the Mode-X screen at the specified line
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        graphics_driver_is_valid : info.graphics_driver = info.graphics_modex
        line_is_valid        : line >= 0 and line <= visible_height
    external
        "IC"
    end  -- feature split_modex_screen


end  -- class SCREEN
