//----------------------------------------------------------------------------
//
// DEGUI - C++ Objects for Allegro's gui 1.1 beta
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
#ifndef ALLEGRO_CPP_GUI_BUILDER_OBJECTS
#define ALLEGRO_CPP_GUI_BUILDER_OBJECTS
//----------------------------------------------------------------------------
#include "allegro.h"
#include "degui.h"
#include "descript.h"

//----------------------------------------------------------------------------
// Allegro dialog managing class for building
//----------------------------------------------------------------------------
class builder_dialog
         :public dialog
         {
         private:
               // Keys used to modify the dialog
               int move_key;
               int multimove_key;
               int resize_key;
               int pushback_key;
               int pullfront_key;
               int delete_key;
               int granularity;

               // Setup the menu stuff
               menu file_menu;
               menu object_menu;
               menu text_menu;
               menu selectable_menu;
               menu panel_menu;
               menu list_menu;
               menu info_menu;
               menu options_menu;
               menu help_menu;
               menu allegro_menu;

               menu_object *main_menu;
               grid_object *grid;


         protected:
               // Add an builder object to the dialog
               void add (dialog_object*);

               static int builder_dialog_proc (int, DIALOG*, int);

         public:
               // Constructors and destructors
               builder_dialog (const int = 100);
               virtual ~builder_dialog (void);

               // Do the dialog  - NOTE: no popup dialog for the builder dialog
               void execute (void) { dialog::execute(NULL); };

               // Change the dialog
               void redraw (const bool total = false) { dialog_do::redraw(total); };
               void close (void) { dialog_do::close(); };
               void exit  (void) { _cant_exit = false; dialog_do::close(); };

               // Object adding routines
               int add_box_object (void);
               int add_shadow_box_object (void);
               int add_panel_raised_object (void);
               int add_panel_sunken_object (void);
               int add_panel_ridge_object (void);
               int add_panel_groove_object (void);
               int add_bitmap_object (void);
               int add_text_object (void);
               int add_centerd_text_object (void);
               int add_edittext_object (void);
               int add_button_object (void);
               int add_checkbox_object (void);
               int add_radio_button_object (void);
               int add_list_object (void);
               int add_textbox_object (void);
               int add_progress_bar_object (void);
               int add_window_object (void);
               int add_user_object (void);
               int add_hidden_list_object (void);

               // Modify how the dialog works
               void set_move_key (const int);
               void set_multimove_key (const int);
               void set_resize_key (const int);
               void set_pushback_key (const int);
               void set_pullfront_key (const int);
               void set_delete_key (const int);
               void set_granularity (const int);

               int get_move_key (void) const { return move_key; };
               int get_multimove_key (void) const { return multimove_key; };
               int get_resize_key (void) const { return resize_key; };
               int get_pushback_key (void) const { return pushback_key; };
               int get_pullfront_key (void) const { return pullfront_key; };
               int get_delete_key (void) const { return delete_key; };
               int get_granularity (void) const { return granularity; };

               // Save and restore the positions of the objects in the dialog
               bool load (const char*, const bool = false);
               void save (const char*);

               // Information functions
               int number_objects (void) { return number-3; };

               // Export the dialog
               void export (const char*);
         };

//----------------------------------------------------------------------------
// The main dialog
extern builder_dialog *gui_builder;

//----------------------------------------------------------------------------
#endif

