//-----------------------------------------------------------------------------
// Functions for the main menu
//-----------------------------------------------------------------------------
#ifndef ALLEGRO_BUILDER_MENU_FUNCTIONS
#define ALLEGRO_BUILDER_MENU_FUNCTIONS

//----------------------------------------------------------------------------
// Export to a dialog
int dialog_export (void);

//----------------------------------------------------------------------------
// Save and load a partially done dialog
int save_dialog (void);
int load_dialog (void);
int append_dialog (void);

//----------------------------------------------------------------------------
// Close the dialog from the menu
int main_dialog_close (void);

//----------------------------------------------------------------------------
// General dialog procedures
int set_builder_palette (void);
int center_dialog (void);
int placement_granularity (void);
int choose_resolution (void);

//----------------------------------------------------------------------------
// Object adding routines

int add_box_object (void);
int add_shadow_box_object (void);
int add_panel_raised_object (void);
int add_panel_sunken_object (void);
int add_panel_ridge_object (void);
int add_panel_groove_object (void);
int add_bitmap_object (void);
int add_text_object (void);
int add_centerd_text_object (void);
int add_edittext_object (void);
int add_button_object (void);
int add_checkbox_object (void);
int add_radio_button_object (void);
int add_list_object (void);
int add_textbox_object (void);
int add_progress_bar_object (void);
int add_window_object (void);
int add_user_object (void);
int add_hidden_list_object (void);

//----------------------------------------------------------------------------
// Help procedures
int help_procedure (void);
int about_procedure (void);

//----------------------------------------------------------------------------
#endif

