//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

ALMOST ALL THE OBJECTS EXAMPLE

  Here we have most of the objects that are available so
  you can see how they are used.

  It's a very heavily modified version of Allegro's EX13.C.

*/
#include <stdlib.h>
#include <stdio.h>

#include "allegro.h"
#include "example.h"

// Include the dialog objects
#include "degui.h"

// The main dialog
dialog the_dialog;

// for the textedit object to play with
char the_string[32] = "Change Me!";

//----------------------------------------------------------------------------
// A custom dialog object for the 'change font' button
class font_button_object
		:public button_object
		{
		private:
            /* we need to load example.dat to access the big font */
            DATAFILE *datafile;

            /* since we change the font, we need to store a copy of the original one */
            FONT *original_font;

            // Actually switch the fonts
            void switch_fonts (void);

		protected:
				virtual void msg_key (void);
				virtual void msg_click (void);

		public:
            // Constructor
				font_button_object (const char*, const char);
            // Destructor
            virtual ~font_button_object (void);
		};

// Font button object constructor
font_button_object::font_button_object (const char *tex, const char c)
   :button_object(tex,c,false)
   {
   // Remember the font
   original_font = font;

   // Load the data file
   datafile = load_datafile("example.dat");
   if(!datafile)
      {
      allegro_exit();
      printf("Error loading example.dat!\n\n");
      exit(1);
      }
   }

// Font button object destructor
font_button_object::~font_button_object (void)
   {
   // Release the datafile
   unload_datafile(datafile);
   }

// Function to change the font when a key is pressed on the font object
void font_button_object::msg_key (void)
	{
   switch_fonts();
	}

// Also change the font on a click
void font_button_object::msg_click (void)
	{
   switch_fonts();

	// Wait for the button up
	while(mouse_b){};
	}

// Actually do the work of switching the fonts
void font_button_object::switch_fonts (void)
   {
	if(font==original_font)
		font = (FONT*)datafile[BIG_FONT].dat;
	else
		font = original_font;

   // Now we need to update the whole screen
   parent()->redraw();
   }

//-----------------------------------------------------------------------------
// Functions for the main menu
//-----------------------------------------------------------------------------
font_button_object test("Another font button",'a');

int add_test_object (void)
   {
   the_dialog.add(test,80,100,220,50);
   return D_O_K;
   }

//----------------------------------------------------------------------------
/* callback function to specify the contents of the listbox */
char *listbox_getter(int index, int *list_size)
   {
   static char *strings[] = {"Zero","One","Two","Three","Four","Five","Six","Seven","Eight","Nine","Ten"};
   if(index<0)
      {
      *list_size = 11;
      return NULL;
      }
   else
      {
      return strings[index];
      }
   }

//----------------------------------------------------------------------------
int main(void)
   {
   char buf1[80], buf2[80], buf3[80];

   /* initialise everything */
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);

   // Use the palette from the bitmap file so
   // that the bitmap looks correct
   PALETTE pal;
   BITMAP *bit = load_pcx("about.pcx",pal);
   set_palette(pal);
   destroy_bitmap(bit);

   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Set up the default colors
   gui_fg_color = makecol8(0,0,0);
   gui_mg_color = makecol8(192,192,192);
   gui_bg_color = makecol8(255,255,255);

   // Declare the dialog objects
   clear_screen_object  clear_obj;
   edittext_object      edit_text(the_string,16);
   button_object			toggle_button("&Toggle me",'t');
   button_object			ok_button("OK",0,true);
   button_object			cancel_button("Cancel",0,true);
   font_button_object	change_font("Change &font",'f');
   list_object				list(listbox_getter);
   radio_button_object	radio1("Radio1",1,false);
   radio_button_object	radio2("Radio2",1,false);
   checkbox_object		check1("Checkbox");
   bitmap_object        bitmap("about.pcx");

   // Setup the menu stuff
   menu add_object_menu;
   add_object_menu.add("Change font button",add_test_object);

   menu allegro_menu;
   allegro_menu.add("&Add",add_object_menu);
   menu_object          menu(allegro_menu);

   // Construct the dialog
   // The position, size and color arguments all have defaults
                              // (x)   (y)   (w)   (h)   (fg)  (bg)
   the_dialog.add(clear_obj);
   the_dialog.add(menu);
   the_dialog.add(edit_text,      40,   52,   380,  38 );
   the_dialog.add(check1,         80,   320,  160,  10 );
   the_dialog.add(radio1,         80,   350,  160,  10 );
   the_dialog.add(radio2,         80,   380,  160,  10 );
   the_dialog.add(toggle_button,  80,   182,  160,  48 );
   the_dialog.add(change_font,    80,   240,  160,  48 );
   the_dialog.add(ok_button,      80,   400,  160,  48 );
   the_dialog.add(list,           360,  180,  206,  180);
   the_dialog.add(cancel_button,  360,  400,  160,  48 );
   the_dialog.add(bitmap,         440,  20);

   // Do the dialog and remember how it was exited
   dialog_object *ret = the_dialog.execute();

   // Report how the dialog was canceled
   if(ret==&ok_button) sprintf(buf1, "dialog was OK'd");
   else if(ret==&cancel_button)  sprintf(buf1, "dialog was canceled");
   else sprintf(buf1, "dialog was escaped");

   // Report other results

   // This line was wrong since the edittext_object uses it's own buffer
   // now and you have to call get_text to get the text out...
   // Wrong line...
//   sprintf(buf2, "string is '%s'", the_string);
   // Corrected line...
   sprintf(buf2, "string is '%s'", edit_text.get_text());

   sprintf(buf3, "listbox selection is %d", list.selection());
   alert(buf1, buf2, buf3, "OK", NULL, 0, 0);

   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------
