//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Simple check box object
//----------------------------------------------------------------------------
// Constructor
checkbox_object::checkbox_object (const char *tex)
   :button_object(tex)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
   set_h(text_height(font)*3/2);
   set_w(text_length(font,(unsigned char*)text) + 2*h());
   }
//----------------------------------------------------------------------------
// Destructor
checkbox_object::~checkbox_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Tell the object to draw itself
void checkbox_object::msg_draw (void)
   {
   _draw_checkbox_object (text,
                          x(), y(), h(),
                          selected(),
                          disabled(), has_focus(),
                          color ? color->fore() : degui_fore_color,
                          color ? color->back() : degui_back_color,
                          color ? color->select() : degui_select_color,
                          color ? color->deselect() : degui_deselect_color,
                          color ? color->disable() : degui_disable_color,
                          color ? color->light_shad() : degui_light_shad_color,
                          color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------

