//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"

//----------------------------------------------------------------------------
// Color scheme class functions
//----------------------------------------------------------------------------
// Constructor
color_scheme::color_scheme (void)
   {
   _fore = degui_fore_color;
   _mid = degui_mid_color;
   _back = degui_back_color;
   _select = degui_select_color;
   _deselect = degui_deselect_color;
   _disable = degui_disable_color;
   _light_shad = degui_light_shad_color;
   _dark_shad = degui_dark_shad_color;
   }
//----------------------------------------------------------------------------
// Destructor
color_scheme::~color_scheme (void)
   {
   }
//----------------------------------------------------------------------------
// Reset the default colors
void color_scheme::reset (const bool force)
   {
   RGB f  = DEFAULT_COLOR_FORE;
   RGB m  = DEFAULT_COLOR_MID;
   RGB b  = DEFAULT_COLOR_BACK;
   RGB l  = DEFAULT_COLOR_LIGHT_SHAD;
   RGB d  = DEFAULT_COLOR_DARK_SHAD;
   RGB s  = DEFAULT_COLOR_SELECT;
   RGB ds = DEFAULT_COLOR_DESELECT;
   RGB di = DEFAULT_COLOR_DISABLE;

   int fc = makecol8(f.r*4,f.g*4,f.b*4);
   int fm = makecol8(m.r*4,m.g*4,m.b*4);
   int fb = makecol8(b.r*4,b.g*4,b.b*4);
   int fl = makecol8(l.r*4,l.g*4,l.b*4);
   int fd = makecol8(d.r*4,d.g*4,d.b*4);
   int fs = makecol8(s.r*4,s.g*4,s.b*4);
   int fds = makecol8(ds.r*4,ds.g*4,ds.b*4);
   int fdi = makecol8(di.r*4,di.g*4,di.b*4);

   if(force==true)
      {
      set_color(fc,&f);
      set_color(fm,&m);
      set_color(fb,&b);
      set_color(fl,&l);
      set_color(fd,&d);
      set_color(fs,&s);
      set_color(fds,&ds);
      set_color(fdi,&di);
      }

   set_fore(fc);
   set_mid(fm);
   set_back(fb);
   set_light_shad(fl);
   set_dark_shad(fd);
   set_select(fs);
   set_deselect(fds);
   set_disable(fdi);
   }
//----------------------------------------------------------------------------

